/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.decomposer;

import com.github.elenterius.biomancy.block.base.HorizontalFacingMachineBlock;
import com.github.elenterius.biomancy.block.base.MachineBlockEntity;
import com.github.elenterius.biomancy.block.decomposer.DecomposerBlockEntity;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class DecomposerBlock
extends HorizontalFacingMachineBlock {
    protected static final VoxelShape AABB = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)17.0, (double)15.0), Block.m_49796_((double)2.0, (double)17.0, (double)2.0, (double)14.0, (double)18.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public DecomposerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.DECOMPOSER.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : DecomposerBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.DECOMPOSER.get()), MachineBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DecomposerBlockEntity decomposer;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DecomposerBlockEntity && (decomposer = (DecomposerBlockEntity)blockEntity).canPlayerInteract(player)) {
            if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)decomposer, buffer -> buffer.m_130064_(pos));
                SoundUtil.broadcastBlockSound((ServerLevel)level, pos, ModSoundEvents.UI_DECOMPOSER_OPEN);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(5) == 0 && Boolean.TRUE.equals(state.m_61143_((Property)CRAFTING))) {
            int particleAmount = random.m_216339_(1, 5);
            int color = 13087069;
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            for (int i = 0; i < particleAmount; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + (double)((random.m_188501_() - random.m_188501_()) * 0.3f), (double)pos.m_123342_() + 0.75, (double)pos.m_123343_() + 0.5 + (double)((random.m_188501_() - random.m_188501_()) * 0.3f), r, g, b);
            }
            if (random.m_188503_(3) == 0) {
                SoundUtil.clientPlayBlockSound(level, pos, ModSoundEvents.DECOMPOSER_CRAFTING_RANDOM, 0.65f);
            }
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        int fuelAmount = DecomposerBlock.getFuelAmount(stack);
        if (fuelAmount > 0) {
            tooltip.add(ComponentUtil.emptyLine());
            DecimalFormat df = ClientTextUtil.getDecimalFormatter("#,###,###");
            tooltip.add((Component)ComponentUtil.translatable("tooltip.biomancy.nutrients_fuel").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)ComponentUtil.literal("%s/%s u".formatted(df.format(fuelAmount), df.format(1000L))).m_130948_(TextStyles.NUTRIENTS));
        }
    }

    public static int getFuelAmount(ItemStack stack) {
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        return tag != null && tag.m_128441_("Fuel") ? tag.m_128469_("Fuel").m_128451_("Amount") : 0;
    }
}

