/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.cradle;

import com.github.elenterius.biomancy.BiomancyConfig;
import com.github.elenterius.biomancy.api.tribute.SacrificeHandler;
import com.github.elenterius.biomancy.api.tribute.SimpleTribute;
import com.github.elenterius.biomancy.api.tribute.Tribute;
import com.github.elenterius.biomancy.block.FleshBlock;
import com.github.elenterius.biomancy.block.base.SimpleSyncedBlockEntity;
import com.github.elenterius.biomancy.block.cradle.PrimalEnergyHandler;
import com.github.elenterius.biomancy.block.cradle.PrimordialCradleBlock;
import com.github.elenterius.biomancy.config.PrimalEnergySettings;
import com.github.elenterius.biomancy.entity.mob.fleshblob.FleshBlob;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import com.github.elenterius.biomancy.util.SaturatedMath;
import com.github.elenterius.biomancy.util.SoundUtil;
import com.github.elenterius.biomancy.util.animation.TriggerableAnimation;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import com.github.elenterius.biomancy.world.mound.MoundGenerator;
import com.github.elenterius.biomancy.world.mound.MoundShape;
import com.github.elenterius.biomancy.world.spatial.SpatialShapeManager;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PrimordialCradleBlockEntity
extends SimpleSyncedBlockEntity
implements PrimalEnergyHandler,
GeoBlockEntity {
    public static final String SACRIFICE_KEY = "SacrificeHandler";
    public static final String PRIMAL_ENERGY_KEY = "PrimalEnergy";
    public static final String PROC_GEN_VALUES_KEY = "ProcGenValues";
    public static final int DURATION_TICKS = 80;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final SacrificeHandler sacrificeHandler = new SacrificeHandler(() -> {
        this.markChunkAsUnsaved();
        this.syncToClient();
    });
    private LazyOptional<IFluidHandler> optionalFluidConsumer = LazyOptional.of(this.sacrificeHandler::getFluidConsumer);
    private long ticks;
    private int primalEnergy;
    @Nullable
    private MoundShape.ProcGenValues procGenValues;

    public PrimordialCradleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PRIMORDIAL_CRADLE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PrimordialCradleBlockEntity cradle) {
        if (cradle.isFull()) {
            ++cradle.ticks;
            if (cradle.ticks > 80L) {
                cradle.onSacrifice((ServerLevel)level);
                cradle.ticks = 0L;
            }
        }
    }

    public void onLoad() {
        MoundShape moundShape;
        MoundShape.ProcGenValues values;
        ServerLevel serverLevel;
        Shape shape;
        super.onLoad();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (shape = SpatialShapeManager.getOrCreateShape(serverLevel = (ServerLevel)level, this.f_58858_, () -> {
            if (this.procGenValues != null) {
                return MoundGenerator.constructShape(this.f_58858_, this.procGenValues);
            }
            return MoundGenerator.constructShape(this.f_58857_, this.f_58858_, this.f_58857_.f_46441_.m_188505_());
        })) instanceof MoundShape && !(values = (moundShape = (MoundShape)shape).getProcGenValues()).equals(this.procGenValues)) {
            this.procGenValues = values;
            this.markChunkAsUnsaved();
        }
    }

    public boolean insertItem(ItemStack stack) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || stack.m_41619_()) {
            return false;
        }
        if (this.sacrificeHandler.isFull()) {
            return false;
        }
        return this.sacrificeHandler.addItem(stack, tribute -> {
            this.markChunkAsUnsaved();
            this.syncToClient();
            this.spawnTributeParticles((ServerLevel)this.f_58857_, (Tribute)tribute);
        });
    }

    private void spawnTributeParticles(ServerLevel level, Tribute tribute) {
        int particleCount;
        int n;
        BlockPos pos = this.m_58899_();
        if (tribute.successModifier() < 0) {
            n = tribute.successModifier() < -99 ? 2 : 0;
            particleCount = level.f_46441_.m_216339_(1 + n, 3 + n);
            this.sendParticlesToClient(level, pos, (ParticleOptions)ParticleTypes.f_123792_, particleCount);
        } else if (tribute.successModifier() > 0) {
            n = Mth.m_14045_((int)(Math.round((float)tribute.lifeEnergy() / 100.0f) * 8), (int)1, (int)8);
            particleCount = level.f_46441_.m_216339_(n, n + 2);
            this.sendParticlesToClient(level, pos, (ParticleOptions)ModParticleTypes.LIGHT_GREEN_GLOW.get(), particleCount);
        }
        if (tribute.lifeEnergy() > 0) {
            n = Mth.m_14045_((int)(Math.round((float)tribute.lifeEnergy() / 100.0f) * 8), (int)1, (int)8);
            particleCount = level.f_46441_.m_216339_(n, n + 2);
            this.sendParticlesToClient(level, pos, (ParticleOptions)ModParticleTypes.PINK_GLOW.get(), particleCount);
        }
        if (tribute.anomalyModifier() > 0) {
            n = Mth.m_14045_((int)(Math.round((float)tribute.anomalyModifier() / 100.0f) * 5), (int)1, (int)5);
            particleCount = level.f_46441_.m_216339_(n, n + 4);
            this.sendParticlesToClient(level, pos, (ParticleOptions)ModParticleTypes.BIOHAZARD.get(), particleCount);
        }
        if (tribute.hostileModifier() > 0) {
            n = Mth.m_14045_((int)(Math.round((float)tribute.hostileModifier() / 100.0f) * 5), (int)1, (int)5);
            particleCount = level.f_46441_.m_216339_(n, n + 4);
            this.sendParticlesToClient(level, pos, (ParticleOptions)ModParticleTypes.HOSTILE.get(), particleCount);
        }
        if (tribute.diseaseModifier() > 0) {
            n = Mth.m_14045_((int)(Math.round((float)tribute.diseaseModifier() / 100.0f) * 8), (int)1, (int)8);
            particleCount = level.f_46441_.m_216339_(n, n + 4);
            this.sendParticlesToClient(level, pos, (ParticleOptions)ParticleTypes.f_123757_, particleCount);
        }
    }

    private void sendParticlesToClient(ServerLevel level, BlockPos pos, ParticleOptions particleOptions, int particleCount) {
        level.m_8767_(particleOptions, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, particleCount, 0.25, 0.25, 0.25, 0.0);
    }

    public boolean isFull() {
        return this.sacrificeHandler.isFull();
    }

    public float getBiomassPct() {
        return this.sacrificeHandler.getBiomassPct();
    }

    public float getLifeEnergyPct() {
        return this.sacrificeHandler.getLifeEnergyPct();
    }

    public float getSuccessChance() {
        return this.sacrificeHandler.getSuccessChance();
    }

    public float getHostileChance() {
        return this.sacrificeHandler.getHostileChance();
    }

    public float getAnomalyChance() {
        return this.sacrificeHandler.getAnomalyChance();
    }

    public float getDiseaseChance() {
        return this.sacrificeHandler.getTumorFactor();
    }

    public boolean hasModifiers() {
        return this.sacrificeHandler.hasModifiers();
    }

    private void resetState() {
        this.sacrificeHandler.reset();
        this.markChunkAsUnsaved();
        this.syncToClient();
    }

    protected void markChunkAsUnsaved() {
        if (this.f_58857_ != null && this.f_58857_.m_46805_(this.f_58858_)) {
            this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
        }
    }

    public void onSacrifice(ServerLevel level) {
        BlockPos pos = this.m_58899_();
        float radius = 8.0f;
        AABB aabb = AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos), (double)(radius * 2.0f), (double)(radius * 2.0f), (double)(radius * 2.0f));
        List nearbyPlayers = level.m_6443_(Player.class, aabb, EntitySelector.f_20408_.and(Entity::m_6084_));
        if (!nearbyPlayers.isEmpty()) {
            Tribute tribute = SimpleTribute.builder().successModifier(1).hostileModifier(-5).build();
            Tribute specialTribute = SimpleTribute.builder().successModifier(20).hostileModifier(-1000).build();
            Set<HashCode> HASHES = Set.of(HashCode.fromString((String)"20f0bf6814e62bb7297669efb542f0af6ee0be1a9b87d0702853d8cc5aa15dc4"), HashCode.fromString((String)"2853ecb1a83a461153a2f8b6a274eab0c4597a9ef7d622673dab419543d486b6"));
            for (Player player : nearbyPlayers) {
                HashCode hashCode;
                for (ItemStack armor : player.m_6168_()) {
                    if (!(armor.m_41720_() instanceof AcolyteArmorItem)) continue;
                    this.sacrificeHandler.addTribute(tribute);
                }
                if (!player.m_6047_() || !HASHES.contains(hashCode = Hashing.sha256().hashString((CharSequence)player.m_20149_(), StandardCharsets.UTF_8))) continue;
                this.sacrificeHandler.addTribute(specialTribute);
            }
        }
        float successChance = this.sacrificeHandler.getSuccessChance();
        float energyMultiplier = this.sacrificeHandler.getLifeEnergyPct();
        if (level.f_46441_.m_188501_() < successChance) {
            if (level.f_46441_.m_188501_() < this.sacrificeHandler.getAnomalyChance()) {
                this.spawnPrimordialFleshBlob(level, pos, this.sacrificeHandler);
                this.addPrimalEnergy(Math.round(4096.0f * energyMultiplier));
                SoundUtil.broadcastBlockSound(level, pos, ModSoundEvents.CRADLE_SPAWN_PRIMORDIAL_MOB);
            } else {
                if (this.sacrificeHandler.getHostileChance() < -4.2f) {
                    this.spawnLegacyFleshBlob(level, pos, this.sacrificeHandler);
                } else {
                    this.spawnFleshBlob(level, pos, this.sacrificeHandler);
                }
                this.addPrimalEnergy(Math.round(2048.0f * energyMultiplier));
                SoundUtil.broadcastBlockSound(level, pos, ModSoundEvents.CRADLE_SPAWN_MOB);
            }
            PrimordialEcosystem.tryToReplaceBlock(level, pos.m_7495_(), ((FleshBlock)((Object)ModBlocks.PRIMAL_FLESH.get())).m_49966_());
            level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        } else if (successChance > 0.75f) {
            if (this.sacrificeHandler.getHostileChance() > 0.6f) {
                this.attackAOE(level, pos);
            }
            this.addPrimalEnergy(Math.round(4096.0f * energyMultiplier));
            if (this.sacrificeHandler.getAnomalyChance() > 0.8f) {
                PrimordialEcosystem.tryToReplaceBlock(level, pos.m_7495_(), ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_());
                PrimordialEcosystem.spreadMalignantVeinsFromSource(level, pos, PrimordialEcosystem.MAX_CHARGE_SUPPLIER);
                SoundUtil.broadcastBlockSound(level, pos, ModSoundEvents.CRADLE_SPAWN_PRIMORDIAL_MOB);
            } else {
                PrimordialEcosystem.tryToReplaceBlock(level, pos.m_7495_(), ((FleshBlock)((Object)ModBlocks.POROUS_PRIMAL_FLESH.get())).m_49966_());
                SoundUtil.broadcastBlockSound(level, pos, ModSoundEvents.CRADLE_SPAWN_MOB);
            }
        } else {
            if (this.sacrificeHandler.getHostileChance() + this.sacrificeHandler.getTumorFactor() > 0.5f) {
                this.attackAOE(level, pos);
            }
            PrimordialEcosystem.tryToReplaceBlock(level, pos.m_7495_(), ((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_());
            PrimordialEcosystem.spreadMalignantVeinsFromSource(level, pos, PrimordialEcosystem.MAX_CHARGE_SUPPLIER);
            this.addPrimalEnergy(Math.round(3072.0f * energyMultiplier));
            SoundUtil.broadcastBlockSound(level, pos, (SoundEvent)ModSoundEvents.FLESH_BLOCK_STEP.get(), 1.0f, 0.15f + level.f_46441_.m_188501_() * 0.5f);
        }
        this.resetState();
    }

    @Override
    public int getPrimalEnergy() {
        PrimalEnergySettings.SupplyAmount supplyAmount = (PrimalEnergySettings.SupplyAmount)((Object)BiomancyConfig.SERVER.primalEnergySupplyOfCradle.get());
        if (supplyAmount == PrimalEnergySettings.SupplyAmount.UNLIMITED) {
            return Integer.MAX_VALUE;
        }
        if (supplyAmount == PrimalEnergySettings.SupplyAmount.NONE) {
            return 0;
        }
        return this.primalEnergy;
    }

    private void addPrimalEnergy(int amount) {
        this.primalEnergy = SaturatedMath.add(this.primalEnergy, amount);
    }

    @Override
    public int fillPrimalEnergy(int amount) {
        if (amount <= 0) {
            return 0;
        }
        int prevPrimalEnergy = this.primalEnergy;
        this.primalEnergy = SaturatedMath.add(this.primalEnergy, amount);
        int filled = this.primalEnergy - prevPrimalEnergy;
        this.m_6596_();
        return filled;
    }

    @Override
    public int drainPrimalEnergy(int amount) {
        if (amount <= 0) {
            return 0;
        }
        PrimalEnergySettings.SupplyAmount supplyAmount = (PrimalEnergySettings.SupplyAmount)((Object)BiomancyConfig.SERVER.primalEnergySupplyOfCradle.get());
        if (supplyAmount == PrimalEnergySettings.SupplyAmount.UNLIMITED) {
            return amount;
        }
        if (supplyAmount == PrimalEnergySettings.SupplyAmount.NONE) {
            return 0;
        }
        if (this.primalEnergy < amount) {
            int prevPrimalEnergy = this.primalEnergy;
            this.primalEnergy = 0;
            this.m_6596_();
            return prevPrimalEnergy;
        }
        this.primalEnergy -= amount;
        this.m_6596_();
        return amount;
    }

    public void spawnPrimordialFleshBlob(ServerLevel level, BlockPos pos, SacrificeHandler sacrificeHandler) {
        EntityType entityType = level.f_46441_.m_188501_() < sacrificeHandler.getHostileChance() ? (EntityType)ModEntityTypes.PRIMORDIAL_HUNGRY_FLESH_BLOB.get() : (EntityType)ModEntityTypes.PRIMORDIAL_FLESH_BLOB.get();
        this.spawnPrimordialFleshBlob(level, pos, (EntityType<? extends FleshBlob>)entityType);
    }

    public void spawnPrimordialFleshBlob(ServerLevel level, BlockPos pos, EntityType<? extends FleshBlob> fleshBlobType) {
        FleshBlob fleshBlob = (FleshBlob)fleshBlobType.m_20615_((Level)level);
        if (fleshBlob != null) {
            float yaw = PrimordialCradleBlock.getYRotation(this.m_58900_());
            fleshBlob.m_7678_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.25f, (float)pos.m_123343_() + 0.5f, yaw, 0.0f);
            fleshBlob.f_20885_ = fleshBlob.m_146908_();
            fleshBlob.f_20883_ = fleshBlob.m_146908_();
            fleshBlob.m_21446_(pos, 32);
            level.m_7967_((Entity)fleshBlob);
        }
    }

    public void spawnLegacyFleshBlob(ServerLevel level, BlockPos pos, SacrificeHandler sacrificeHandler) {
        this.spawnFleshBlob(level, pos, sacrificeHandler, (EntityType<? extends FleshBlob>)((EntityType)ModEntityTypes.LEGACY_FLESH_BLOB.get()));
    }

    public void spawnFleshBlob(ServerLevel level, BlockPos pos, SacrificeHandler sacrificeHandler) {
        EntityType entityType = level.f_46441_.m_188501_() < sacrificeHandler.getHostileChance() ? (EntityType)ModEntityTypes.HUNGRY_FLESH_BLOB.get() : (EntityType)ModEntityTypes.FLESH_BLOB.get();
        this.spawnFleshBlob(level, pos, sacrificeHandler, (EntityType<? extends FleshBlob>)entityType);
    }

    public void spawnFleshBlob(ServerLevel level, BlockPos pos, SacrificeHandler sacrificeHandler, EntityType<? extends FleshBlob> fleshBlobType) {
        FleshBlob fleshBlob = (FleshBlob)fleshBlobType.m_20615_((Level)level);
        if (fleshBlob != null) {
            float yaw = PrimordialCradleBlock.getYRotation(this.m_58900_());
            fleshBlob.m_7678_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.25f, (float)pos.m_123343_() + 0.5f, yaw, 0.0f);
            fleshBlob.f_20885_ = fleshBlob.m_146908_();
            fleshBlob.f_20883_ = fleshBlob.m_146908_();
            fleshBlob.setTumors(sacrificeHandler.getTumorFactor());
            fleshBlob.m_21446_(pos, 24);
            level.m_7967_((Entity)fleshBlob);
        }
    }

    public void attackAOE() {
        Level level;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.attackAOE(serverLevel, this.f_58858_);
        }
    }

    protected void attackAOE(ServerLevel level, BlockPos pos) {
        this.broadcastAnimation(Animations.SPIKE_ATTACK);
        SoundUtil.broadcastBlockSound(level, pos, ModSoundEvents.CRADLE_SPIKE_ATTACK);
        float maxAttackDistance = 1.5f;
        float maxAttackDistanceSqr = maxAttackDistance * maxAttackDistance;
        Vec3 origin = Vec3.m_82512_((Vec3i)pos);
        AABB aabb = AABB.m_165882_((Vec3)origin, (double)(maxAttackDistance * 2.0f), (double)(maxAttackDistance * 2.0f), (double)(maxAttackDistance * 2.0f));
        List victims = level.m_6249_((Entity)null, aabb, EntitySelector.f_20403_);
        for (Entity entity : victims) {
            float distSqr = (float)entity.m_20238_(origin);
            float pct = distSqr / maxAttackDistanceSqr;
            float damage = Mth.m_14036_((float)(8.0f * (1.0f - pct)), (float)0.5f, (float)8.0f);
            entity.m_6469_(ModDamageSources.primalSpikes((Level)level, origin), damage);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(SACRIFICE_KEY, (Tag)this.sacrificeHandler.serializeNBT());
        tag.m_128405_(PRIMAL_ENERGY_KEY, this.primalEnergy);
        if (this.procGenValues != null) {
            CompoundTag tagProcGen = new CompoundTag();
            this.procGenValues.writeTo(tagProcGen);
            tag.m_128365_(PROC_GEN_VALUES_KEY, (Tag)tagProcGen);
        }
    }

    @Override
    protected void saveForSyncToClient(CompoundTag tag) {
        tag.m_128365_(SACRIFICE_KEY, (Tag)this.sacrificeHandler.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(SACRIFICE_KEY)) {
            this.sacrificeHandler.deserializeNBT(tag.m_128469_(SACRIFICE_KEY));
        }
        this.primalEnergy = tag.m_128451_(PRIMAL_ENERGY_KEY);
        if (tag.m_128441_(PROC_GEN_VALUES_KEY)) {
            this.procGenValues = MoundShape.ProcGenValues.readFrom(tag.m_128469_(PROC_GEN_VALUES_KEY));
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optionalFluidConsumer.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.optionalFluidConsumer = LazyOptional.of(this.sacrificeHandler::getFluidConsumer);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.f_58859_) {
            return super.getCapability(cap, side);
        }
        if (cap == ModCapabilities.FLUID_HANDLER) {
            return this.optionalFluidConsumer.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void broadcastAnimation(TriggerableAnimation animation) {
        this.triggerAnim(animation.controller(), animation.name());
    }

    protected <T extends PrimordialCradleBlockEntity> PlayState handleAnimationState(AnimationState<T> state) {
        if (state.getController().getAnimationState() == AnimationController.State.STOPPED) {
            state.getController().setAnimation(Animations.IDLE.rawAnimation());
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "main", 0, this::handleAnimationState);
        Animations.registerTriggerableAnimations(controller);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static final class Animations {
        static final String MAIN_CONTROLLER = "main";
        private static final List<TriggerableAnimation> TRIGGERABLE_ANIMATIONS = new ArrayList<TriggerableAnimation>();
        static final TriggerableAnimation IDLE = Animations.register("main", "idle", RawAnimation.begin().thenPlay("cradle.idle"));
        static final TriggerableAnimation WORK = Animations.register("main", "work", RawAnimation.begin().thenPlay("cradle.work"));
        static final TriggerableAnimation SPIKE_ATTACK = Animations.register("main", "spike_attack", RawAnimation.begin().thenPlay("cradle.spike"));

        private Animations() {
        }

        static TriggerableAnimation register(String controller, String name, RawAnimation rawAnimation) {
            TriggerableAnimation animation = new TriggerableAnimation(controller, name, rawAnimation);
            TRIGGERABLE_ANIMATIONS.add(animation);
            return animation;
        }

        static void registerTriggerableAnimations(AnimationController<?> controller) {
            for (TriggerableAnimation animation : TRIGGERABLE_ANIMATIONS) {
                if (!animation.controller().equals(controller.getName())) continue;
                controller.triggerableAnim(animation.name(), animation.rawAnimation());
            }
        }
    }
}

