/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.base;

import com.github.elenterius.biomancy.block.base.MachineBlockEntity;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class MachineBlock
extends BaseEntityBlock {
    public static final BooleanProperty CRAFTING = ModBlockProperties.IS_CRAFTING;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    protected MachineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CRAFTING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, CRAFTING});
    }

    protected int getRedstoneLevel(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)POWERED)) ? 15 : 0;
    }

    protected int getPoweredDuration() {
        return 2;
    }

    protected void updateNeighbors(Level level, BlockPos pos) {
        level.m_46672_(pos, (Block)this);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (Boolean.TRUE.equals(state.m_61143_((Property)POWERED))) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.FALSE), 3);
            this.updateNeighbors((Level)level, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (Boolean.TRUE.equals(state.m_61143_((Property)POWERED))) {
                this.updateNeighbors(level, pos);
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof MachineBlockEntity) {
                MachineBlockEntity machine = (MachineBlockEntity)blockEntity;
                machine.dropAllInvContents(level, pos);
            }
            if (Boolean.TRUE.equals(state.m_61143_((Property)CRAFTING))) {
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void powerBlock(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.TRUE), 3);
        this.updateNeighbors(level, pos);
        level.m_186460_(pos, (Block)this, this.getPoweredDuration());
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getRedstoneLevel(state);
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getRedstoneLevel(state);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return Boolean.TRUE.equals(state.m_61143_((Property)CRAFTING)) ? 15 : 0;
    }
}

