/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block;

import com.github.elenterius.biomancy.block.property.DirectionalSlabType;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DirectionalSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<DirectionalSlabType> TYPE = ModBlockProperties.DIRECTIONAL_SLAB_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE_UP = VoxelShapeUtil.createXZRotatedTowards(Direction.UP, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape SHAPE_DOWN = VoxelShapeUtil.createXZRotatedTowards(Direction.DOWN, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape SHAPE_NORTH = VoxelShapeUtil.createXZRotatedTowards(Direction.NORTH, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape SHAPE_SOUTH = VoxelShapeUtil.createXZRotatedTowards(Direction.SOUTH, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape SHAPE_EAST = VoxelShapeUtil.createXZRotatedTowards(Direction.EAST, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape SHAPE_WEST = VoxelShapeUtil.createXZRotatedTowards(Direction.WEST, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);

    public DirectionalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)DirectionalSlabType.HALF_UP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState state, FluidState fluidState) {
        return state.m_61143_(TYPE) != DirectionalSlabType.FULL && super.m_7361_(pLevel, pPos, state, fluidState);
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return state.m_61143_(TYPE) != DirectionalSlabType.FULL && super.m_6044_(level, pos, state, fluid);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isWaterlogged;
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(clickedPos);
        boolean bl = isWaterlogged = level.m_6425_(clickedPos).m_76152_() == Fluids.f_76193_;
        if (state.m_60713_((Block)this) && state.m_61143_(TYPE) != DirectionalSlabType.FULL) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)DirectionalSlabType.FULL))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        DirectionalSlabType type = DirectionalSlabType.getHalfFrom(clickedPos, context.m_43720_(), context.m_43719_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)type))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public BlockState getStateForPlacement(BlockGetter level, BlockPos pos, Direction direction) {
        boolean isWaterlogged;
        BlockState state = level.m_8055_(pos);
        boolean bl = isWaterlogged = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        if (state.m_60713_((Block)this) && state.m_61143_(TYPE) != DirectionalSlabType.FULL) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)DirectionalSlabType.FULL))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        DirectionalSlabType type = DirectionalSlabType.getHalfFrom(direction);
        return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)type))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack stack = useContext.m_43722_();
        DirectionalSlabType type = (DirectionalSlabType)((Object)state.m_61143_(TYPE));
        if (type != DirectionalSlabType.FULL && stack.m_150930_(this.m_5456_())) {
            if (useContext.m_7058_()) {
                Direction clickedFace = useContext.m_43719_();
                return type.getFacing() == clickedFace;
            }
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED))) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != DirectionalSlabType.FULL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotationDirection) {
        DirectionalSlabType type = (DirectionalSlabType)((Object)state.m_61143_(TYPE));
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type.rotate(rotationDirection)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        DirectionalSlabType type = (DirectionalSlabType)((Object)state.m_61143_(TYPE));
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type.mirror(mirror)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((DirectionalSlabType)((Object)state.m_61143_(TYPE))) {
            case DirectionalSlabType.HALF_DOWN -> SHAPE_DOWN;
            case DirectionalSlabType.HALF_UP -> SHAPE_UP;
            case DirectionalSlabType.HALF_NORTH -> SHAPE_NORTH;
            case DirectionalSlabType.HALF_SOUTH -> SHAPE_SOUTH;
            case DirectionalSlabType.HALF_WEST -> SHAPE_WEST;
            case DirectionalSlabType.HALF_EAST -> SHAPE_EAST;
            default -> Shapes.m_83144_();
        };
    }

    public boolean m_7357_(BlockState pState, BlockGetter plevel, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> false;
            case PathComputationType.WATER -> plevel.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        };
    }
}

