/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.tribute.fluid;

import com.github.elenterius.biomancy.api.tribute.Tributes;
import com.github.elenterius.biomancy.api.tribute.fluid.FluidToTributeConversion;
import com.github.elenterius.biomancy.api.tribute.fluid.FluidTribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class FluidTributes {
    private static final Map<ResourceLocation, FluidToTributeConversion> FLUIDS = new HashMap<ResourceLocation, FluidToTributeConversion>();
    private static final FluidTribute MILK_MILLI_TRIBUTE = FluidTribute.of(Tributes.getTribute(Items.f_42455_.m_7968_()), 1000);

    private FluidTributes() {
    }

    @Nullable
    private static ResourceLocation getRegistryKey(Fluid fluid) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)fluid;
            fluid = flowingFluid.m_5613_();
        }
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    public static void register(Fluid fluid, FluidToTributeConversion func) {
        ResourceLocation key = FluidTributes.getRegistryKey(fluid);
        if (key == null) {
            throw new IllegalArgumentException("Couldn't find a valid registry key for fluid " + fluid);
        }
        FLUIDS.put(key, func);
    }

    public static void register(RegistryObject<? extends Fluid> fluidHolder, FluidToTributeConversion func) {
        ResourceLocation key = fluidHolder.getId();
        FLUIDS.put(key, func);
    }

    public static void register(ResourceLocation fluidRegistryKey, FluidToTributeConversion func) {
        FLUIDS.put(fluidRegistryKey, func);
    }

    public static boolean isValid(FluidStack fluidStack) {
        ResourceLocation key = FluidTributes.getRegistryKey(fluidStack.getFluid());
        return key != null && FLUIDS.containsKey(key);
    }

    @Nullable
    public static FluidToTributeConversion getConversion(FluidStack fluidStack) {
        ResourceLocation key = FluidTributes.getRegistryKey(fluidStack.getFluid());
        if (key == null) {
            return null;
        }
        return FLUIDS.get(key);
    }

    static {
        FluidTributes.register((Fluid)ForgeMod.MILK.get(), (FluidStack resource) -> MILK_MILLI_TRIBUTE);
    }
}

