/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.nutrients.fluid;

import com.github.elenterius.biomancy.api.nutrients.FuelHandler;
import com.github.elenterius.biomancy.api.nutrients.fluid.FluidNutrients;
import com.github.elenterius.biomancy.api.nutrients.fluid.FluidToFuelConversion;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class FluidFuelConsumerHandler
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    public static final String MILLI_FUEL_BUFFER_KEY = "MilliFuelBuffer";
    private final FuelHandler fuelHandler;
    private long milliFuelBuffer;

    public FluidFuelConsumerHandler(FuelHandler fuelHandler) {
        this.fuelHandler = fuelHandler;
    }

    public boolean isFluidValid(int tank, FluidStack resource) {
        return FluidNutrients.isValid(resource);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (this.fuelHandler.getFuelAmount() >= this.fuelHandler.getMaxFuelAmount()) {
            return 0;
        }
        FluidToFuelConversion conversion = FluidNutrients.getConversion(resource);
        if (conversion == null) {
            return 0;
        }
        int milliFuel = conversion.getMilliFuelPerUnit(resource);
        if (milliFuel <= 0) {
            return 0;
        }
        long amountToConsume = resource.getAmount();
        int fuelYield = (int)((this.milliFuelBuffer + (long)milliFuel * amountToConsume) / 1000L);
        if (fuelYield > 0) {
            long remainder;
            int fuelToFill = Math.min(this.fuelHandler.getMaxFuelAmount() - this.fuelHandler.getFuelAmount(), fuelYield);
            long fuelMissing = (long)fuelToFill * 1000L - this.milliFuelBuffer;
            amountToConsume = (int)(fuelMissing / (long)milliFuel);
            if (action.simulate()) {
                return (int)amountToConsume;
            }
            this.fuelHandler.addFuelAmount(fuelToFill);
            this.milliFuelBuffer = remainder = (long)milliFuel * amountToConsume - fuelMissing;
        } else {
            if (action.simulate()) {
                return (int)amountToConsume;
            }
            this.milliFuelBuffer += (long)milliFuel * amountToConsume;
        }
        return (int)amountToConsume;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return this.fuelHandler.getMaxFuelAmount();
    }

    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_(MILLI_FUEL_BUFFER_KEY, this.milliFuelBuffer);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.milliFuelBuffer = tag.m_128454_(MILLI_FUEL_BUFFER_KEY);
    }
}

