/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.livingtool;

import com.github.elenterius.biomancy.api.livingtool.LivingTool;
import com.github.elenterius.biomancy.api.livingtool.LivingToolState;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface SpecialLivingTool
extends LivingTool {
    default public LivingToolState getLivingToolState(ItemStack livingTool) {
        return LivingToolState.deserialize(livingTool.m_41784_());
    }

    default public void setLivingToolState(ItemStack livingTool, LivingToolState state) {
        state.serialize(livingTool.m_41784_());
    }

    default public void updateLivingToolState(ItemStack livingTool, ServerLevel level, Player player) {
        LivingToolState state = this.getLivingToolState(livingTool);
        boolean hasNutrients = this.hasNutrients(livingTool);
        if (state == LivingToolState.DORMANT) {
            this.setLivingToolState(livingTool, hasNutrients ? LivingToolState.AWAKENED : LivingToolState.BROKEN);
            SoundUtil.broadcastItemSound(level, (LivingEntity)player, (SoundEvent)ModSoundEvents.FLESH_BLOCK_PLACE.get());
        } else if (state == LivingToolState.AWAKENED) {
            this.setLivingToolState(livingTool, hasNutrients ? LivingToolState.DORMANT : LivingToolState.BROKEN);
            SoundUtil.broadcastItemSound(level, (LivingEntity)player, (SoundEvent)ModSoundEvents.FLESH_BLOCK_HIT.get());
        }
    }

    @Override
    default public void onNutrientsChanged(ItemStack livingTool, int oldValue, int newValue) {
        int maxCost;
        LivingToolState prevState;
        LivingToolState state = prevState = this.getLivingToolState(livingTool);
        if (newValue <= 0) {
            if (state != LivingToolState.BROKEN) {
                this.setLivingToolState(livingTool, LivingToolState.BROKEN);
            }
            return;
        }
        if (state == LivingToolState.BROKEN) {
            state = LivingToolState.DORMANT;
        }
        if (newValue < (maxCost = this.getLivingToolMaxActionCost(livingTool, state))) {
            if (state == LivingToolState.AWAKENED) {
                state = LivingToolState.DORMANT;
            } else if (state == LivingToolState.DORMANT) {
                state = LivingToolState.BROKEN;
            }
        }
        if (state != prevState) {
            this.setLivingToolState(livingTool, state);
        }
    }

    @Override
    default public int getLivingToolActionCost(ItemStack livingTool, ToolAction toolAction) {
        LivingToolState state = this.getLivingToolState(livingTool);
        return this.getLivingToolActionCost(livingTool, state, toolAction);
    }

    default public int getLivingToolActionCost(ItemStack livingTool, LivingToolState state, ToolAction toolAction) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case LivingToolState.BROKEN -> 0;
            case LivingToolState.DORMANT -> 1;
            case LivingToolState.AWAKENED -> 2;
        };
    }

    default public int getLivingToolMaxActionCost(ItemStack livingTool, LivingToolState state) {
        return ToolAction.getActions().stream().filter(arg_0 -> ((ItemStack)livingTool).canPerformAction(arg_0)).map(toolAction -> this.getLivingToolActionCost(livingTool, state, (ToolAction)toolAction)).max(Integer::compareTo).orElse(0);
    }

    @Override
    default public void appendLivingToolTooltip(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)this.getLivingToolState(stack).getTooltip().m_130948_(TextStyles.ITALIC_GRAY));
        tooltip.add(ComponentUtil.emptyLine());
        LivingTool.super.appendLivingToolTooltip(stack, tooltip);
    }
}

