/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.livingtool;

import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.api.nutrients.NutrientsContainerItem;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface LivingTool
extends NutrientsContainerItem {
    public static final Set<Enchantment> INVALID_ENCHANTMENTS = Set.of(Enchantments.f_44990_, Enchantments.f_44981_, Enchantments.f_44966_, Enchantments.f_44986_);

    default public boolean isValidEnchantment(ItemStack livingTool, Enchantment enchantment) {
        return enchantment.f_44672_ != EnchantmentCategory.BREAKABLE && !INVALID_ENCHANTMENTS.contains(enchantment);
    }

    @Override
    default public boolean isValidNutrientsResource(ItemStack container, ItemStack resource) {
        return Nutrients.isValidRepairMaterial(resource);
    }

    @Override
    default public int getNutrientsResourceValue(ItemStack container, ItemStack resource) {
        return Nutrients.getRepairValue(resource);
    }

    public int getLivingToolActionCost(ItemStack var1, ToolAction var2);

    default public void appendLivingToolTooltip(ItemStack stack, List<Component> tooltip) {
        DecimalFormat df = ClientTextUtil.getDecimalFormatter("#,###,###");
        tooltip.add((Component)TextComponentUtil.getTooltipText("nutrients_fuel").m_130948_(TextStyles.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" %s/%s".formatted(df.format(this.getNutrients(stack)), df.format(this.getMaxNutrients(stack)))).m_130948_(TextStyles.NUTRIENTS));
    }
}

