/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.AbstractItemEditorConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.GhostDropReceiver;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomCheckbox;
import dev.ftb.mods.ftbfiltersystem.filter.NbtFilter;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NBTConfigScreen
extends AbstractItemEditorConfigScreen<NbtFilter>
implements GhostDropReceiver {
    private CustomCheckbox fuzzyCB;

    public NBTConfigScreen(NbtFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 320, 176);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        MutableComponent str = Component.m_237115_((String)"ftbfiltersystem.gui.fuzzy_match");
        this.fuzzyCB = (CustomCheckbox)this.m_142416_((GuiEventListener)new CustomCheckbox(this.leftPos + 180, this.topPos + 110, this.f_96547_.m_92852_((FormattedText)str), 20, (Component)str, ((NbtFilter)this.filter).isFuzzyMatch()));
        this.editBox.m_240159_(((NbtFilter)this.filter).getTag().toString());
    }

    @Override
    protected void doScheduledUpdate() {
        if (this.editBox.m_239249_().isEmpty()) {
            this.setStatus(true, (Component)Component.m_237119_(), null);
        } else {
            try {
                NbtFilter.fromString(((NbtFilter)this.filter).getParent(), this.editBox.m_239249_());
                this.setStatus(true, (Component)Component.m_237115_((String)"ftbfiltersystem.gui.nbt_ok"), null);
            }
            catch (FilterException e) {
                this.setStatus(false, (Component)Component.m_237115_((String)"ftbfiltersystem.gui.nbt_bad"), e.getMessage());
            }
        }
    }

    @Override
    @Nullable
    protected NbtFilter makeNewFilter() {
        try {
            String str = NbtFilter.getNBTPrefix(this.fuzzyCB.selected()) + this.editBox.m_239249_();
            return NbtFilter.fromString(((NbtFilter)this.filter).getParent(), str);
        }
        catch (FilterException e) {
            return null;
        }
    }

    @Override
    protected Predicate<ItemStack> inventoryChecker() {
        return ItemStack::m_41782_;
    }

    @Override
    protected String serialize(ItemStack stack) {
        return Objects.requireNonNull(stack.m_41783_()).toString();
    }

    @Override
    public Rect2i getGhostDropRegion() {
        return new Rect2i(this.editBox.m_252754_(), this.editBox.m_252907_(), this.editBox.m_5711_(), this.editBox.m_93694_());
    }

    @Override
    public void receiveGhostDrop(ItemStack stack) {
        if (stack.m_41782_()) {
            this.editBox.m_240159_(this.serialize(stack));
            this.customHoverName = stack.m_41788_() ? stack.m_41786_() : null;
            this.m_7522_((GuiEventListener)this.editBox);
        }
    }
}

