/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.GuiUtil;
import dev.ftb.mods.ftbfiltersystem.client.gui.GhostDropReceiver;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.ItemWidget;
import dev.ftb.mods.ftbfiltersystem.filter.ItemFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.HolderLookup;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ItemConfigScreen
extends AbstractFilterConfigScreen<ItemFilter>
implements GhostDropReceiver {
    private static final ResourceLocation SCROLL_TEXTURE = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int SEARCH_ROWS = 4;
    private static final int SEARCH_COLS = 9;
    private static ItemSource itemSource = ItemSource.CREATIVE;
    private static String lastSearch = "";
    private static List<SearchEntry> cachedCreativeEntries;
    private static List<SearchEntry> cachedInventoryEntries;
    private final List<ItemStack> currentStacks = new ArrayList<ItemStack>();
    private Rect2i scrollArea;
    private double currentScroll;
    private boolean isScrolling;
    private EditBox searchField;
    private final List<SearchItemWidget> itemWidgets = new ArrayList<SearchItemWidget>();
    private ItemWidget selectedWidget;

    public ItemConfigScreen(ItemFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 194, 115);
        cachedInventoryEntries = null;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.searchField = this.makeSearchEditBox(this.leftPos + 8, this.topPos + 38, () -> lastSearch, s -> {
            lastSearch = s;
        });
        this.m_142416_((GuiEventListener)this.searchField);
        this.m_7522_((GuiEventListener)this.searchField);
        this.selectedWidget = (ItemWidget)this.m_142416_((GuiEventListener)new ItemWidget(this.leftPos + 8, this.topPos + 17, 18, 18, ItemStack.f_41583_));
        int btnWidth = Arrays.stream(ItemSource.values()).map(val -> this.f_96547_.m_92852_((FormattedText)val.getDisplayName())).max(Integer::compareTo).orElse(50) + 10;
        this.m_142416_((GuiEventListener)CycleButton.m_168894_(ItemSource::getDisplayName).m_168961_((Object[])ItemSource.values()).m_168929_().m_168948_((Object)itemSource).m_168936_(this.leftPos + this.guiWidth - btnWidth - 21, this.topPos + 5, btnWidth, 16, (Component)Component.m_237119_(), (btn, val) -> {
            itemSource = val;
            this.updateSearchEntries();
        }));
        this.itemWidgets.clear();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                SearchItemWidget w = new SearchItemWidget(row, col);
                this.itemWidgets.add(w);
                this.m_142416_((GuiEventListener)w);
            }
        }
        this.scrollArea = new Rect2i(this.leftPos + 174, this.topPos + 52, 14, 70);
        this.setSelectedStack(new ItemStack((ItemLike)((ItemFilter)this.filter).getMatchItem()));
        this.updateSearchEntries();
    }

    private void setSelectedStack(ItemStack stack) {
        this.selectedWidget.setStack(stack.m_41777_());
    }

    @Override
    protected void doScheduledUpdate() {
        this.updateSearchEntries();
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        int sx = this.scrollArea.m_110085_();
        int sy1 = this.scrollArea.m_110086_();
        int sy2 = sy1 + this.scrollArea.m_110091_();
        FormattedText txt = GuiUtil.ellipsize(this.f_96547_, (FormattedText)this.selectedWidget.getStack().m_41720_().m_41466_(), this.leftPos + this.guiWidth - (this.selectedWidget.m_252754_() + this.selectedWidget.m_5711_() + 6));
        guiGraphics.m_280649_(this.f_96547_, Language.m_128107_().m_5536_(txt), this.selectedWidget.m_252754_() + this.selectedWidget.m_5711_() + 3, this.selectedWidget.m_252907_() + 8, 0x404040, false);
        guiGraphics.m_280509_(this.scrollArea.m_110085_() - 2, this.scrollArea.m_110086_() - 2, this.scrollArea.m_110085_() + this.scrollArea.m_110090_(), this.scrollArea.m_110086_() + this.scrollArea.m_110091_(), -8355712);
        guiGraphics.m_280509_(this.scrollArea.m_110085_() - 1, this.scrollArea.m_110086_() - 1, this.scrollArea.m_110085_() + this.scrollArea.m_110090_() - 1, this.scrollArea.m_110086_() + this.scrollArea.m_110091_() - 1, -6250336);
        guiGraphics.m_280218_(SCROLL_TEXTURE, sx, sy1 + (int)((double)(sy2 - sy1 - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
    }

    public boolean m_6050_(double x, double y, double dir) {
        if (dir != 0.0 && this.needsScrollBars()) {
            int j = this.currentStacks.size() / 10 - 3 + 1;
            float i = dir > 0.0 ? 1.0f : -1.0f;
            this.scrollTo(Mth.m_14008_((double)(this.currentScroll - (double)(i / (float)j)), (double)0.0, (double)1.0));
            return true;
        }
        return super.m_6050_(x, y, dir);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl = this.isScrolling = button == 0 && this.needsScrollBars() && this.scrollArea.m_110087_((int)mouseX, (int)mouseY);
        if (this.isScrolling) {
            this.scrollToMouse(mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            this.scrollToMouse(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    protected ItemFilter makeNewFilter() {
        return new ItemFilter(((ItemFilter)this.filter).getParent(), this.selectedWidget.getStack().m_41720_());
    }

    private boolean needsScrollBars() {
        return this.currentStacks.size() > 36;
    }

    private void scrollToMouse(double mouseY) {
        this.scrollTo(Mth.m_14008_((double)((mouseY - (double)this.scrollArea.m_110086_()) / (double)this.scrollArea.m_110091_()), (double)0.0, (double)1.0));
    }

    private void scrollTo(double scrollPos) {
        this.currentScroll = scrollPos;
        int i = this.currentStacks.size() / 9 - 4 + 1;
        int j = Math.max(0, (int)(this.currentScroll * (double)i + 0.5));
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int idx = col + (row + j) * 9;
                ItemStack stack = idx >= 0 && idx < this.currentStacks.size() ? this.currentStacks.get(idx) : ItemStack.f_41583_;
                this.itemWidgets.get(row * 9 + col).setStack(stack);
            }
        }
    }

    private void updateSearchEntries() {
        this.currentStacks.clear();
        String srch = this.searchField.m_94155_().toLowerCase();
        List<ItemStack> applicableEntries = itemSource.get().stream().filter(entry -> entry.test(srch)).map(entry -> entry.stack).toList();
        this.currentStacks.addAll(applicableEntries);
        this.scrollTo(0.0);
    }

    @Override
    public Rect2i getGhostDropRegion() {
        return new Rect2i(this.selectedWidget.m_252754_(), this.selectedWidget.m_252907_(), this.selectedWidget.m_5711_(), this.selectedWidget.m_93694_());
    }

    @Override
    public void receiveGhostDrop(ItemStack stack) {
        this.selectedWidget.setStack(stack);
    }

    static enum ItemSource {
        CREATIVE(ItemSource::getCreativeItems, "creative"),
        INV(ItemSource::getInventoryItems, "inventory");

        private final Supplier<List<SearchEntry>> itemSupplier;
        private final Component name;

        private ItemSource(Supplier<List<SearchEntry>> itemSupplier, String name) {
            this.itemSupplier = itemSupplier;
            this.name = Component.m_237115_((String)("ftbfiltersystem.gui.item_source." + name));
        }

        List<SearchEntry> get() {
            return this.itemSupplier.get();
        }

        public Component getDisplayName() {
            return this.name;
        }

        private static List<SearchEntry> getCreativeItems() {
            if (cachedCreativeEntries == null) {
                CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlags.f_244332_, (boolean)false, (HolderLookup.Provider)Minecraft.m_91087_().f_91073_.m_9598_());
                cachedCreativeEntries = CreativeModeTabs.m_258007_().m_260957_().stream().map(SearchEntry::new).toList();
            }
            return cachedCreativeEntries;
        }

        private static List<SearchEntry> getInventoryItems() {
            if (cachedInventoryEntries == null) {
                int i;
                Inventory inv = Minecraft.m_91087_().f_91074_.m_150109_();
                cachedInventoryEntries = new ArrayList<SearchEntry>();
                for (i = 9; i < 36; ++i) {
                    cachedInventoryEntries.add(new SearchEntry((ItemStack)inv.f_35974_.get(i)));
                }
                for (i = 0; i < 9; ++i) {
                    cachedInventoryEntries.add(new SearchEntry((ItemStack)inv.f_35974_.get(i)));
                }
            }
            return cachedInventoryEntries;
        }
    }

    private class SearchItemWidget
    extends ItemWidget {
        public SearchItemWidget(int row, int col) {
            super(ItemConfigScreen.this.leftPos + 8 + 18 * col, ItemConfigScreen.this.topPos + 50 + 18 * row, 18, 18, ItemStack.f_41583_);
        }

        @Override
        protected void handleClick(boolean doubleClick) {
            if (doubleClick) {
                ItemConfigScreen.this.applyChanges();
            } else {
                ItemConfigScreen.this.setSelectedStack(this.getStack());
            }
        }

        @Nullable
        public Tooltip m_278622_() {
            return super.m_278622_();
        }
    }

    static class SearchEntry
    implements Predicate<String> {
        public final ItemStack stack;
        private final String tooltip;

        SearchEntry(ItemStack stack) {
            List l;
            this.stack = stack;
            try {
                Minecraft mc = Minecraft.m_91087_();
                l = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)).stream().map(Component::getString).collect(Collectors.toList());
            }
            catch (Exception ignored) {
                l = Collections.emptyList();
            }
            this.tooltip = String.join((CharSequence)"\n", l).toLowerCase();
        }

        @Override
        public boolean test(String searchString) {
            return this.tooltip.contains(searchString);
        }
    }
}

