/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class FilterSystemCommands {
    public static final DynamicCommandExceptionType PARSE_FAILED = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"ftbfiltersystem.message.parse_failed", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType NOT_A_FILTER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbfiltersystem.message.not_a_filter"));
    public static final SimpleCommandExceptionType NO_OFFHAND_ITEM = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"ftbfiltersystem.message.no_offhand_item"));
    private static final Component TICK_MARK = Component.m_237113_((String)"\u2713 ").m_130940_(ChatFormatting.GREEN);
    private static final Component X_MARK = Component.m_237113_((String)"\u2717 ").m_130940_(ChatFormatting.RED);

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbfiltersystem").then(Commands.m_82127_((String)"parse").then(Commands.m_82129_((String)"string", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FilterSystemCommands.tryParseCommand((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"string")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get_filter").executes(ctx -> FilterSystemCommands.tryShowFilter((CommandSourceStack)ctx.getSource(), false))).then(Commands.m_82127_((String)"pretty").executes(ctx -> FilterSystemCommands.tryShowFilter((CommandSourceStack)ctx.getSource(), true))))).then(Commands.m_82127_((String)"set_filter").then(Commands.m_82129_((String)"string", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FilterSystemCommands.trySetFilter((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"string")))))).then(Commands.m_82127_((String)"try_match").executes(ctx -> FilterSystemCommands.tryMatch((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump_nbt").requires(ctx -> ctx.m_6761_(2))).executes(ctx -> FilterSystemCommands.dumpNbt((CommandSourceStack)ctx.getSource()))));
    }

    private static int tryParseCommand(CommandSourceStack source, String string) throws CommandSyntaxException {
        try {
            for (DumpedFilter entry : FTBFilterSystemAPI.api().dump(FilterParser.parse(string))) {
                source.m_288197_(() -> {
                    MutableComponent txt = entry.filter().getDisplayName().m_6881_().m_130940_(ChatFormatting.AQUA);
                    if (!(entry.filter() instanceof SmartFilter.Compound)) {
                        txt.m_130946_(" ").m_7220_((Component)entry.filter().getDisplayArg().m_6881_().m_130940_(ChatFormatting.YELLOW));
                    }
                    return Component.m_237113_((String)FilterSystemCommands.makeDumpPrefix(entry.indent())).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)txt);
                }, false);
            }
        }
        catch (FilterException e) {
            throw PARSE_FAILED.create((Object)e.getMessage());
        }
        return 0;
    }

    private static int tryShowFilter(CommandSourceStack source, boolean prettyPrint) throws CommandSyntaxException {
        String filterString = SmartFilterItem.getFilterString(FilterSystemCommands.getHeldFilter(source));
        if (prettyPrint) {
            return FilterSystemCommands.tryParseCommand(source, filterString);
        }
        source.m_288197_(() -> Component.m_237113_((String)filterString), false);
        return 1;
    }

    private static int trySetFilter(CommandSourceStack source, String string) throws CommandSyntaxException {
        try {
            SmartFilterItem.setFilter(FilterSystemCommands.getHeldFilter(source), FilterParser.parse(string).toString());
            return 1;
        }
        catch (FilterException e) {
            source.m_81352_((Component)Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    public static int tryMatch(CommandSourceStack source) throws CommandSyntaxException {
        ItemStack offhandItem = source.m_81375_().m_21206_();
        if (offhandItem.m_41619_()) {
            throw NO_OFFHAND_ITEM.create();
        }
        SmartFilter filter = FilterParser.parse(SmartFilterItem.getFilterString(FilterSystemCommands.getHeldFilter(source)));
        if (filter.test(offhandItem)) {
            source.m_288197_(() -> TICK_MARK.m_6881_().m_7220_((Component)Component.m_237110_((String)"ftbfiltersystem.message.matched", (Object[])new Object[]{offhandItem.m_41611_()})), false);
            return 1;
        }
        source.m_288197_(() -> X_MARK.m_6881_().m_7220_((Component)Component.m_237110_((String)"ftbfiltersystem.message.not_matched", (Object[])new Object[]{offhandItem.m_41611_()})), false);
        return 0;
    }

    private static int dumpNbt(CommandSourceStack source) throws CommandSyntaxException {
        ItemStack stack = source.m_81375_().m_21205_();
        if (stack.m_41782_()) {
            source.m_288197_(() -> Component.m_237113_((String)"NBT dump:").m_130940_(ChatFormatting.YELLOW), false);
            source.m_288197_(() -> Component.m_237113_((String)stack.m_41783_().toString()), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"No NBT").m_130940_(ChatFormatting.RED));
        return 0;
    }

    private static ItemStack getHeldFilter(CommandSourceStack source) throws CommandSyntaxException {
        ItemStack stack = source.m_81375_().m_21205_();
        if (stack.m_41720_() instanceof SmartFilterItem) {
            return stack;
        }
        throw NOT_A_FILTER.create();
    }

    private static String makeDumpPrefix(int indent) {
        if (indent == 0) {
            return "";
        }
        String s1 = "\u2503 ".repeat(indent - 1);
        return s1 + "\u2523\u2501";
    }
}

