/*
 * Decompiled with CFR 0.152.
 */
package fuzs.climaterivers.init;

import fuzs.climaterivers.init.ModPlacedFeatures;
import fuzs.climaterivers.init.ModRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModBiomes {
    public static final ResourceKey<Biome> COLD_RIVER_BIOME = ModRegistry.REGISTRIES.makeResourceKey(Registries.f_256952_, "cold_river");
    public static final ResourceKey<Biome> LUKEWARM_RIVER_BIOME = ModRegistry.REGISTRIES.makeResourceKey(Registries.f_256952_, "lukewarm_river");
    public static final ResourceKey<Biome> WARM_RIVER_BIOME = ModRegistry.REGISTRIES.makeResourceKey(Registries.f_256952_, "warm_river");

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter placedFeatureLookup = context.m_255420_(Registries.f_256988_);
        HolderGetter configuredCarverLookup = context.m_255420_(Registries.f_257003_);
        context.m_255272_(COLD_RIVER_BIOME, (Object)ModBiomes.coldRiver((HolderGetter<PlacedFeature>)placedFeatureLookup, configuredCarverLookup));
        context.m_255272_(LUKEWARM_RIVER_BIOME, (Object)ModBiomes.lukeWarmRiver((HolderGetter<PlacedFeature>)placedFeatureLookup, configuredCarverLookup));
        context.m_255272_(WARM_RIVER_BIOME, (Object)ModBiomes.warmRiver((HolderGetter<PlacedFeature>)placedFeatureLookup, configuredCarverLookup));
    }

    public static Biome coldRiver(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder builder = ModBiomes.riverSpawns();
        builder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
        BiomeGenerationSettings.Builder builder2 = ModBiomes.baseRiverGeneration(placedFeatures, worldCarvers);
        ModBiomes.addGravellySoftDisks(builder2);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)builder2);
        builder2.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195221_);
        return OverworldBiomes.m_271953_((boolean)true, (float)0.25f, (float)0.8f, (int)4020182, (int)329011, null, null, (MobSpawnSettings.Builder)builder, (BiomeGenerationSettings.Builder)builder2, null);
    }

    public static Biome lukeWarmRiver(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder builder = ModBiomes.riverSpawns();
        builder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 1, 1, 5));
        builder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20556_, 4, 1, 5));
        BiomeGenerationSettings.Builder builder2 = ModBiomes.baseRiverGeneration(placedFeatures, worldCarvers);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)builder2);
        builder2.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)builder2);
        builder2.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195221_);
        return OverworldBiomes.m_271953_((boolean)true, (float)0.95f, (float)0.9f, (int)4566514, (int)267827, null, null, (MobSpawnSettings.Builder)builder, (BiomeGenerationSettings.Builder)builder2, null);
    }

    public static Biome warmRiver(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder builder = ModBiomes.riverSpawns();
        builder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 5, 1, 5));
        BiomeGenerationSettings.Builder builder2 = ModBiomes.baseRiverGeneration(placedFeatures, worldCarvers);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)builder2);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)builder2);
        builder2.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)builder2);
        builder2.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195221_);
        return OverworldBiomes.m_271953_((boolean)false, (float)2.0f, (float)0.0f, (int)4445678, (int)270131, null, null, (MobSpawnSettings.Builder)builder, (BiomeGenerationSettings.Builder)builder2, null);
    }

    public static MobSpawnSettings.Builder riverSpawns() {
        MobSpawnSettings.Builder builder = new MobSpawnSettings.Builder().m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 2, 1, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)builder);
        builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 100, 1, 1));
        return builder;
    }

    public static BiomeGenerationSettings.Builder baseRiverGeneration(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        OverworldBiomes.m_194869_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)builder);
        return builder;
    }

    public static void addGravellySoftDisks(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.DISK_SAND_PLACED_FEATURE);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MiscOverworldPlacements.f_195268_);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.DISK_GRAVEL_PLACED_FEATURE);
    }
}

