/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.mehvahdjukaar.supplementaries.common.entities.ISlimeable;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;

public abstract class SlimedOverlayHud {
    protected final Minecraft mc;

    protected SlimedOverlayHud(Minecraft minecraft) {
        this.mc = minecraft;
    }

    protected void render(GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        float alpha = ISlimeable.getAlpha((LivingEntity)this.mc.f_91074_, partialTicks);
        if (alpha > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
            int slide = (int)((float)screenHeight / 3.0f * (1.0f - alpha));
            this.blit(graphics, ModTextures.SLIME_GUI_OVERLAY, 0, 0, -90, 0.0f, 0.0f, screenWidth, screenHeight + slide, screenWidth, screenHeight + slide);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void blit(GuiGraphics gui, ResourceLocation atlasLocation, int x, int y, int blitOffset, float uOffset, float vOffset, float uWidth, float vHeight, int textureWidth, int textureHeight) {
        this.blit(gui, atlasLocation, x, (float)x + uWidth, y, (float)y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blit(GuiGraphics gui, ResourceLocation atlasLocation, float x1, float x2, float y1, float y2, int blitOffset, float uWidth, float vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        this.innerBlit(gui, atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + vHeight) / (float)textureHeight);
    }

    public void innerBlit(GuiGraphics gui, ResourceLocation atlasLocation, float x1, float x2, float y1, float y2, float blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = gui.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, x1, y1, blitOffset).m_7421_(minU, minV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x1, y2, blitOffset).m_7421_(minU, maxV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x2, y2, blitOffset).m_7421_(maxU, maxV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x2, y1, blitOffset).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

