/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.util;

import com.google.common.base.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class Resolvable<T> {
    private static final ThreadLocal<Resolvable> MAP_KEY = ThreadLocal.withInitial(() -> new Resolvable(null, null, null));
    private ResourceLocation id;
    private Registry<T> registry;
    private Optional<T> resolved;
    private final boolean resolvedImmediately;

    private Resolvable(ResourceLocation id, Registry<T> registry, Optional<T> resolved) {
        this.id = id;
        this.registry = registry;
        this.resolved = resolved;
        this.resolvedImmediately = resolved != null && resolved.isPresent();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Optional<T> get() {
        if (this.resolved == null) {
            throw new IllegalStateException("Cannot resolve a mapKey resolvable");
        }
        if (!this.resolved.isPresent()) {
            this.resolved = this.registry.m_6612_(this.id);
        }
        return this.resolved;
    }

    public T getOrNull() {
        return this.get().orElse(null);
    }

    public boolean isResolved() {
        if (this.resolved == null) {
            throw new IllegalStateException("Cannot resolve a mapKey resolvable");
        }
        return this.resolved.isPresent();
    }

    public boolean wasResolvedImmediately() {
        if (this.resolved == null) {
            throw new IllegalStateException("Cannot resolve a mapKey resolvable");
        }
        return this.resolvedImmediately;
    }

    public static <T> Resolvable<T> of(ResourceLocation id, Registry<T> registry) {
        return new Resolvable<T>(id, registry, registry.m_6612_(id));
    }

    public static <T> Resolvable<T> mapKey(T obj, Registry<T> registry) {
        return Resolvable.mapKey(registry.m_7981_(obj), registry);
    }

    public static <T> Resolvable<T> mapKey(ResourceLocation id, Registry<T> registry) {
        Resolvable r = MAP_KEY.get();
        r.id = id;
        r.registry = registry;
        return r;
    }

    public String toString() {
        if (this.resolved == null) {
            return "Resolvable(MapKey){id=" + String.valueOf(this.id) + "}";
        }
        return "Resolvable{id=" + String.valueOf(this.id) + ",resolved=" + this.isResolved() + ",resolvedImmediately=" + this.resolvedImmediately + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.registry == null ? 0 : this.registry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resolvable other = (Resolvable)obj;
        if (!Objects.equal((Object)this.id, (Object)other.id)) {
            return false;
        }
        return this.registry == other.registry;
    }
}

