/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.QDIni;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class ParsedTime {
    private static final int SECOND_IN_TICKS = 20;
    private static final int MINUTE_IN_TICKS = 1200;
    private static final int HOUR_IN_TICKS = 72000;
    private static final Map<BiFunction<Integer, Boolean, ParsedTime>, Map<Integer, Map<Boolean, ParsedTime>>> cache = new HashMap<BiFunction<Integer, Boolean, ParsedTime>, Map<Integer, Map<Boolean, ParsedTime>>>();
    public final int timeInTicks;
    public final boolean priority;

    private ParsedTime(int timeInTicks, boolean priority) {
        this.timeInTicks = timeInTicks;
        this.priority = priority;
    }

    public boolean overshadows(ParsedTime that) {
        if (this == that) {
            return false;
        }
        if (this instanceof Unset) {
            return false;
        }
        if (that instanceof Unset) {
            return true;
        }
        if (that.priority && !this.priority) {
            return false;
        }
        if (this.priority && !that.priority) {
            return true;
        }
        if (this instanceof Invincible && that instanceof Forever) {
            return true;
        }
        return this.timeInTicks > that.timeInTicks;
    }

    public String toString() {
        Object s = this instanceof Unset ? "unset" : (this instanceof Forever ? "forever" : (this instanceof Invincible ? "invincible" : (this instanceof Instant ? "instantly" : (this.timeInTicks % 72000 == 0 ? this.timeInTicks / 72000 + "h" : (this.timeInTicks % 1200 == 0 ? this.timeInTicks / 1200 + "m" : (this.timeInTicks % 20 == 0 ? this.timeInTicks / 20 + "s" : this.timeInTicks + "t"))))));
        return (String)s + (this.priority ? "!" : "");
    }

    public static ParsedTime getFrom(QDIni cfg, String k) {
        String v = cfg.get(k).orElse("");
        try {
            return ParsedTime.parse(v);
        }
        catch (IllegalArgumentException e) {
            FabLog.warn(k + " must be one of unset, forever, f, invincible, invulnerable, i, instantly, or a timespec like 30s (got " + v + ") at " + cfg.getBlame(k));
            return ParsedTime.cached(Unset::new, 6000, false);
        }
    }

    public static ParsedTime parse(String time) {
        Preconditions.checkNotNull((Object)time);
        if (time.isEmpty()) {
            throw new IllegalArgumentException("Timespec cannot be blank");
        }
        boolean priority = false;
        if (time.endsWith("!")) {
            priority = true;
            time = time.substring(0, time.length() - 1);
        }
        switch (time) {
            case "unset": {
                return ParsedTime.cached(Unset::new, 6000, priority);
            }
            case "forever": 
            case "f": {
                return ParsedTime.cached(Forever::new, Integer.MAX_VALUE, priority);
            }
            case "invincible": 
            case "invulnerable": 
            case "i": {
                return ParsedTime.cached(Invincible::new, Integer.MAX_VALUE, priority);
            }
            case "instantly": 
            case "0": {
                return ParsedTime.cached(Instant::new, 0, priority);
            }
        }
        char qualifier = time.charAt(time.length() - 1);
        String timeNumPart = time.substring(0, time.length() - 1);
        if (!CharMatcher.digit().matchesAllOf((CharSequence)timeNumPart)) {
            throw new IllegalArgumentException("Bad timespec " + time);
        }
        return ParsedTime.cached(ParsedTime::new, new BigDecimal(timeNumPart).multiply(new BigDecimal(switch (qualifier) {
            case 't' -> 1;
            case 's' -> 20;
            case 'm' -> 1200;
            case 'h' -> 72000;
            default -> throw new IllegalArgumentException("Unknown qualifier " + qualifier + " for time value " + time);
        })).intValueExact(), priority);
    }

    private static ParsedTime cached(BiFunction<Integer, Boolean, ParsedTime> constructor, int time, boolean priority) {
        Map<Boolean, ParsedTime> pCache = ParsedTime.buildCache(constructor, time);
        ParsedTime ret = pCache.get(priority);
        if (ret == null) {
            ret = constructor.apply(time, priority);
            pCache.put(priority, ret);
        }
        return ret;
    }

    public static void clearCache() {
        cache.clear();
        ParsedTime.buildCache(Unset::new, Unset.NORMAL.timeInTicks).put(Unset.NORMAL.priority, Unset.NORMAL);
    }

    private static Map<Boolean, ParsedTime> buildCache(BiFunction<Integer, Boolean, ParsedTime> constructor, int time) {
        return cache.computeIfAbsent(constructor, k -> new HashMap()).computeIfAbsent(time, k -> new HashMap());
    }

    public static class Unset
    extends ParsedTime {
        public static final Unset NORMAL = new Unset(6000, false);

        private Unset(int timeInTicks, boolean priority) {
            super(6000, priority);
        }
    }

    public static class Invincible
    extends ParsedTime {
        private Invincible(int timeInTicks, boolean priority) {
            super(Integer.MAX_VALUE, priority);
        }
    }

    public static class Forever
    extends ParsedTime {
        private Forever(int timeInTicks, boolean priority) {
            super(Integer.MAX_VALUE, priority);
        }
    }

    public static class Instant
    extends ParsedTime {
        private Instant(int timeInTicks, boolean priority) {
            super(0, priority);
        }
    }
}

