/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import com.google.common.reflect.ClassPath;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.SpecialEligibility;
import com.unascribed.fabrication.support.injection.FabInjector;
import com.unascribed.fabrication.support.injection.FabModifyConstInjectionInfo;
import com.unascribed.fabrication.support.injection.FabRefMap;
import com.unascribed.fabrication.support.injection.FailsoftCallbackInjectionInfo;
import com.unascribed.fabrication.support.injection.FailsoftModifyArgInjectionInfo;
import com.unascribed.fabrication.support.injection.FailsoftModifyVariableInjectionInfo;
import com.unascribed.fabrication.support.injection.Hijack;
import com.unascribed.fabrication.support.injection.ModifyReturn;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.util.asm.MethodNodeEx;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    public static final String MOD_NAME = EarlyAgnos.isForge() ? "Forgery" : "Fabrication";
    public static final String MOD_NAME_LOWER = EarlyAgnos.isForge() ? "forgery" : "fabrication";
    public static final String MOD_NAME_LOWER_OTHER = !EarlyAgnos.isForge() ? "forgery" : "fabrication";
    private static final SetMultimap<String, String> configKeysForDiscoveredClasses = HashMultimap.create();
    public static boolean loadComplete = false;

    public void onLoad(String mixinPackage) {
        Path target = EarlyAgnos.getConfigDir().resolve(MOD_NAME_LOWER);
        Path source = EarlyAgnos.getConfigDir().resolve(EarlyAgnos.isForge() ? "fabrication" : "forgery");
        if (!Files.exists(target, new LinkOption[0]) && Files.exists(source, new LinkOption[0])) {
            try {
                Files.move(source, target, new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FabConf.reload();
        InjectionInfo.register(FailsoftCallbackInjectionInfo.class);
        InjectionInfo.register(FailsoftModifyArgInjectionInfo.class);
        InjectionInfo.register(FailsoftModifyVariableInjectionInfo.class);
        InjectionInfo.register(FabModifyConstInjectionInfo.class);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        MixinConfigPlugin.checkFailOn("com.unascribed.fabrication.mixin");
        return MixinConfigPlugin.discoverClassesInPackage("com.unascribed.fabrication.mixin", true);
    }

    public static void checkFailOn(String pkg) {
        try {
            int count = 0;
            int failed = 0;
            block13: for (ClassInfo ci : MixinConfigPlugin.getClassesInPackage(pkg)) {
                Object v;
                String k;
                int i;
                if (ci.getName().contains("$")) continue;
                ++count;
                String truncName = ci.getName().substring(pkg.length() + 1);
                FabLog.debug("--");
                FabLog.debug((Math.random() < 0.01 ? "\ud83d\udc45" : "\ud83d\udc40") + " Checking for failure " + truncName);
                ClassReader cr = new ClassReader(ci.asByteSource().read());
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 7);
                if (cn.visibleAnnotations == null) continue;
                HashSet<String> foundFeatures = new HashSet<String>();
                for (AnnotationNode an : cn.visibleAnnotations) {
                    if (!an.desc.equals("Lcom/unascribed/fabrication/support/EligibleIf;") || an.values == null) continue;
                    for (i = 0; i < an.values.size(); i += 2) {
                        k = (String)an.values.get(i);
                        v = an.values.get(i + 1);
                        if (k.equals("configAvailable")) {
                            foundFeatures.add((String)v);
                            continue;
                        }
                        if (!k.equals("anyConfigAvailable")) continue;
                        foundFeatures.addAll((List)v);
                    }
                }
                if (foundFeatures.isEmpty()) continue;
                for (AnnotationNode an : cn.visibleAnnotations) {
                    if (!an.desc.equals("Lcom/unascribed/fabrication/support/FailOn;") || an.values == null) continue;
                    for (i = 0; i < an.values.size(); i += 2) {
                        k = (String)an.values.get(i);
                        v = an.values.get(i + 1);
                        if (k.equals("modLoaded")) {
                            for (String s : (List)v) {
                                if (!EarlyAgnos.isModLoaded(s)) continue;
                                int cid = s.indexOf(58);
                                if (cid != -1) {
                                    s = s.substring(cid + 1);
                                }
                                for (String fk2 : foundFeatures) {
                                    FabConf.addFailure(fk2, "Incompatible mod: " + s);
                                }
                                continue block13;
                            }
                            continue;
                        }
                        if (k.equals("modNotLoaded")) {
                            for (String s : (List)v) {
                                if (EarlyAgnos.isModLoaded(s)) continue;
                                int cid = s.indexOf(58);
                                if (cid != -1) {
                                    s = s.substring(cid + 1);
                                }
                                for (String fk : foundFeatures) {
                                    FabConf.addFailure(fk, "Requires mod: " + s);
                                }
                                continue block13;
                            }
                            continue;
                        }
                        if (k.equals("classPresent")) {
                            for (String s : (List)v) {
                                try {
                                    Class.forName(s, false, MixinConfigPlugin.class.getClassLoader());
                                    for (String string : foundFeatures) {
                                        FabConf.addFailure(string, "Incompatible class: " + s);
                                    }
                                }
                                catch (ClassNotFoundException cid) {
                                }
                            }
                            continue;
                        }
                        if (k.equals("classNotPresent")) {
                            for (String s : (List)v) {
                                try {
                                    Class.forName(s, false, MixinConfigPlugin.class.getClassLoader());
                                }
                                catch (ClassNotFoundException e) {
                                    for (String fk : foundFeatures) {
                                        FabConf.addFailure(fk, "Requires class: " + s);
                                    }
                                }
                            }
                            continue;
                        }
                        if (k.equals("invertedSpecialConditions")) {
                            List li = (List)v;
                            if (li.isEmpty()) continue;
                            for (String[] e : li) {
                                if (!"Lcom/unascribed/fabrication/support/SpecialEligibility;".equals(e[0])) {
                                    FabLog.debug("Unknown FailOn special condition type " + e[0] + " - ignoring");
                                    continue;
                                }
                                try {
                                    SpecialEligibility specialEligibility = SpecialEligibility.valueOf(e[1]);
                                    if (FabConf.isMet(specialEligibility)) continue;
                                    String reason = "Unknown condition";
                                    switch (specialEligibility) {
                                        case FORGE: 
                                        case NOT_FORGE: 
                                        case NEVER: {
                                            reason = "Not Ported";
                                            break;
                                        }
                                        case NOT_MACOS: {
                                            reason = "MacOS Not Supported";
                                            break;
                                        }
                                        case NO_OPTIFINE: {
                                            reason = "Optifine Not Supported";
                                        }
                                    }
                                    for (String fk : foundFeatures) {
                                        FabConf.addFailure(fk, reason);
                                    }
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    FabLog.debug("Unknown FailOn special condition " + e[1]);
                                    for (String fk : foundFeatures) {
                                        FabConf.addFailure(fk, "Unknown failure condition : " + e[1]);
                                    }
                                }
                            }
                            continue;
                        }
                        FabLog.warn("Unknown annotation setting for FailOn " + k);
                    }
                }
            }
            FabLog.debug("Failing pass complete. Found " + count + " candidates, failed " + failed + ".");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> discoverClassesInPackage(String pkg, boolean truncate) {
        FabLog.debug("Starting discovery pass...");
        try {
            int count = 0;
            int enabled = 0;
            int skipped = 0;
            ArrayList rtrn = Lists.newArrayList();
            for (ClassInfo ci : MixinConfigPlugin.getClassesInPackage(pkg)) {
                if (ci.getName().contains("$")) continue;
                ++count;
                String truncName = ci.getName().substring(pkg.length() + 1);
                FabLog.debug("--");
                FabLog.debug((Math.random() < 0.01 ? "\ud83d\udc45" : "\ud83d\udc40") + " Considering " + truncName);
                ClassReader cr = new ClassReader(ci.asByteSource().read());
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 7);
                boolean eligible = true;
                ArrayList eligibilityFailures = Lists.newArrayList();
                ArrayList eligibilityNotes = Lists.newArrayList();
                ArrayList eligibilitySuccesses = Lists.newArrayList();
                boolean anyRestrictions = false;
                if (cn.visibleAnnotations != null) {
                    int i;
                    List fakeMixin = null;
                    for (AnnotationNode an : cn.visibleAnnotations) {
                        if (!an.desc.equals("Lcom/unascribed/fabrication/support/injection/FakeMixinHack;") || an.values == null) continue;
                        for (i = 0; i < an.values.size(); i += 2) {
                            if (!"value".equals(an.values.get(i))) continue;
                            fakeMixin = (List)an.values.get(i + 1);
                        }
                    }
                    for (AnnotationNode an : cn.visibleAnnotations) {
                        if (!an.desc.equals("Lcom/unascribed/fabrication/support/EligibleIf;") || an.values == null) continue;
                        for (i = 0; i < an.values.size(); i += 2) {
                            anyRestrictions = true;
                            String k = (String)an.values.get(i);
                            Object v = an.values.get(i + 1);
                            if (k.equals("configAvailable")) {
                                if (!FabConf.isValid((String)v)) {
                                    FabLog.debug("\ud83d\ude48 Dev error! Exploding.");
                                    throw FabConf.devError(cn.name.substring(pkg.length() + 1).replace('/', '.') + " references an unknown config key " + String.valueOf(v) + "\n\nDid you forget to add it to features.txt and run build-features.sh?");
                                }
                                if (FabConf.isFailed((String)v)) {
                                    eligibilityFailures.add("Required config setting " + FabConf.remap((String)v) + " has failed injects");
                                    eligible = false;
                                }
                                if (FabConf.limitRuntimeConfigs() && !FabConf.isEnabled((String)v)) {
                                    eligibilityFailures.add("Required config setting " + FabConf.remap((String)v) + " is not enabled and limit_runtime_configs is on");
                                    eligible = false;
                                } else if (FabConf.isBanned((String)v)) {
                                    eligibilityFailures.add("Required config setting " + FabConf.remap((String)v) + " is banned");
                                    eligible = false;
                                } else {
                                    eligibilitySuccesses.add("Required config key " + FabConf.remap((String)v) + " is not banned");
                                }
                                configKeysForDiscoveredClasses.put((Object)ci.getName(), (Object)((String)v));
                                if (fakeMixin == null) continue;
                                for (String fm : fakeMixin) {
                                    configKeysForDiscoveredClasses.put((Object)fm, (Object)((String)v));
                                }
                                continue;
                            }
                            if (k.equals("envMatches")) {
                                String[] arr = (String[])v;
                                if (!arr[0].equals("Lcom/unascribed/fabrication/support/Env;")) continue;
                                Env e = Env.valueOf(arr[1]);
                                Env curEnv = EarlyAgnos.getCurrentEnv();
                                if (!curEnv.matches(e)) {
                                    eligibilityFailures.add("Environment is incorrect (want " + e.name().toLowerCase(Locale.ROOT) + ", got " + curEnv.name().toLowerCase(Locale.ROOT) + ")");
                                    eligible = false;
                                    continue;
                                }
                                eligibilitySuccesses.add("Environment is correct (" + e.name().toLowerCase(Locale.ROOT) + ")");
                                continue;
                            }
                            if (k.equals("modLoaded")) {
                                for (String s : (List)v) {
                                    if (!EarlyAgnos.isModLoaded(s)) {
                                        eligibilityFailures.add("Required mod " + s + " is not loaded");
                                        eligible = false;
                                        continue;
                                    }
                                    eligibilitySuccesses.add("Required mod " + s + " is loaded");
                                }
                                continue;
                            }
                            if (k.equals("modNotLoaded")) {
                                for (String s : (List)v) {
                                    if (EarlyAgnos.isModLoaded(s)) {
                                        eligibilityFailures.add("Conflicting mod " + s + " is loaded");
                                        eligible = false;
                                        continue;
                                    }
                                    eligibilitySuccesses.add("Conflicting mod " + s + " is not loaded");
                                }
                                continue;
                            }
                            if (k.equals("classPresent")) {
                                for (String s : (List)v) {
                                    try {
                                        Class.forName(s, false, MixinConfigPlugin.class.getClassLoader());
                                        eligibilitySuccesses.add("Required class " + s + " is present");
                                    }
                                    catch (ClassNotFoundException e) {
                                        eligibilityFailures.add("Required class " + s + " is not present");
                                        eligible = false;
                                    }
                                }
                                continue;
                            }
                            if (k.equals("classNotPresent")) {
                                for (String s : (List)v) {
                                    try {
                                        Class.forName(s, false, MixinConfigPlugin.class.getClassLoader());
                                        eligibilityFailures.add("Conflicting class " + s + " is present");
                                        eligible = false;
                                    }
                                    catch (ClassNotFoundException e) {
                                        eligibilitySuccesses.add("Conflicting class " + s + " is not present");
                                    }
                                }
                                continue;
                            }
                            if (k.equals("anyConfigAvailable")) {
                                boolean allBanned = true;
                                boolean runtimeCheck = FabConf.limitRuntimeConfigs();
                                boolean allFailed = true;
                                for (String s : (List)v) {
                                    if (FabConf.isFailed(s = FabConf.remap(s))) {
                                        eligibilityFailures.add("Required config setting " + s + " has failed injects");
                                    } else {
                                        allFailed = false;
                                    }
                                    if (runtimeCheck && FabConf.isEnabled(s)) {
                                        runtimeCheck = false;
                                    }
                                    if (FabConf.isBanned(s)) {
                                        eligibilityNotes.add("Relevant config setting " + s + " is banned");
                                    } else {
                                        allBanned = false;
                                        eligibilitySuccesses.add("Relevant config setting " + s + " is not banned");
                                    }
                                    configKeysForDiscoveredClasses.put((Object)ci.getName(), (Object)s);
                                    if (fakeMixin == null) continue;
                                    for (String fm : fakeMixin) {
                                        configKeysForDiscoveredClasses.put((Object)fm, (Object)s);
                                    }
                                }
                                if (allFailed) {
                                    eligibilityFailures.add("All of the relevant config settings failed to inject");
                                    eligible = false;
                                    continue;
                                }
                                if (runtimeCheck) {
                                    eligibilityFailures.add("All of the relevant config settings are off while limit_runtime_configs is on");
                                    eligible = false;
                                    continue;
                                }
                                if (!allBanned) continue;
                                eligibilityFailures.add("All of the relevant config settings are banned");
                                eligible = false;
                                continue;
                            }
                            if (k.equals("specialConditions")) {
                                List li = (List)v;
                                if (li.isEmpty()) {
                                    eligibilityNotes.add("Special conditions is present but empty - ignoring");
                                    continue;
                                }
                                for (String[] e : li) {
                                    if (!"Lcom/unascribed/fabrication/support/SpecialEligibility;".equals(e[0])) {
                                        eligibilityNotes.add("Unknown special condition type " + e[0] + " - ignoring");
                                        continue;
                                    }
                                    try {
                                        SpecialEligibility se = SpecialEligibility.valueOf(e[1]);
                                        if (FabConf.isMet(se)) {
                                            eligibilitySuccesses.add("Special condition " + String.valueOf((Object)se) + " is met");
                                            continue;
                                        }
                                        eligibilityFailures.add("Special condition " + String.valueOf((Object)se) + " is not met");
                                        eligible = false;
                                    }
                                    catch (IllegalArgumentException ex) {
                                        eligibilityFailures.add("Unknown special condition " + e[1]);
                                        eligible = false;
                                    }
                                }
                                continue;
                            }
                            FabLog.warn("Unknown annotation setting for EligibleIf " + k);
                        }
                    }
                }
                if (!anyRestrictions) {
                    eligibilityNotes.add("No restrictions on eligibility");
                }
                for (String s : eligibilityNotes) {
                    FabLog.debug("  \u2139\ufe0f " + s);
                }
                for (String s : eligibilitySuccesses) {
                    FabLog.debug("  \u2705 " + s);
                }
                for (String s : eligibilityFailures) {
                    FabLog.debug("  \u274c " + s);
                }
                if (eligible) {
                    ++enabled;
                    FabLog.debug("\ud83d\udc4d Eligibility requirements met. Applying " + truncName);
                    rtrn.add(truncate ? truncName : ci.getName());
                    continue;
                }
                ++skipped;
                FabLog.debug("\u270b Eligibility requirements not met. Skipping " + truncName);
            }
            FabLog.debug("Discovery pass complete. Found " + count + " candidates, enabled " + enabled + ", skipped " + skipped + ".");
            return rtrn;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Iterable<ClassInfo> getClassesInPackage(String pkg) {
        block12: {
            try {
                InputStream is;
                block13: {
                    is = MixinConfigPlugin.class.getClassLoader().getResourceAsStream("classes.txt");
                    if (is == null) break block12;
                    break block13;
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                ArrayList rtrn = Lists.newArrayList();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
                String prefix = pkg.replace('.', '/') + "/";
                while (true) {
                    String line;
                    if ((line = br.readLine()) == null) {
                        ArrayList arrayList = rtrn;
                        return arrayList;
                    }
                    if (!line.startsWith(prefix)) continue;
                    rtrn.add(new BareClassInfo(line, MixinConfigPlugin.class.getClassLoader()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return Iterables.transform((Iterable)ClassPath.from((ClassLoader)MixinConfigPlugin.class.getClassLoader()).getTopLevelClassesRecursive(pkg), GuavaClassInfo::new);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (FabConf.limitRuntimeConfigs()) {
            MixinConfigPlugin.finalizeIsEnabled(targetClass);
        }
        MixinConfigPlugin.fakeMixinHack(targetClass);
        FabInjector.apply(targetClass);
        MixinConfigPlugin.lithiumCompat(targetClass, mixinClassName);
        if (targetClass.visibleAnnotations != null) {
            targetClass.visibleAnnotations.removeIf(an -> an.desc.startsWith("Lcom/unascribed/fabrication"));
        }
    }

    public static void fakeMixinHack(ClassNode targetClass) {
        if (targetClass.visibleAnnotations == null) {
            return;
        }
        for (AnnotationNode annotationNode : targetClass.visibleAnnotations) {
            Object list;
            if (!"Lcom/unascribed/fabrication/support/injection/FakeMixinHack;".equals(annotationNode.desc) || !((list = annotationNode.values.get(annotationNode.values.indexOf("value") + 1)) instanceof List) || ((List)list).isEmpty() || !(((List)list).get(0) instanceof String)) continue;
            ArrayList<FabInjector.ToInject> toInject = new ArrayList<FabInjector.ToInject>();
            for (String className : (List)list) {
                Class<?> cl;
                try {
                    cl = Class.forName(className);
                }
                catch (Exception ignore) {
                    continue;
                }
                for (Method mthd : cl.getMethods()) {
                    ModifyReturn mr = mthd.getAnnotation(ModifyReturn.class);
                    Hijack hi = mthd.getAnnotation(Hijack.class);
                    String[] method = null;
                    String[] target = null;
                    String desc = null;
                    if (mr != null) {
                        method = mr.method();
                        target = mr.target();
                        desc = "Lcom/unascribed/fabrication/support/injection/ModifyReturn;";
                    } else if (hi != null) {
                        method = hi.method();
                        target = hi.target();
                        desc = "Lcom/unascribed/fabrication/support/injection/Hijack;";
                    }
                    if (target == null || method == null || desc == null) continue;
                    toInject.add(new FabInjector.ToInject(Arrays.stream(method).map(s -> FabRefMap.relativeMap(cl.getName(), s)).collect(Collectors.toList()), Arrays.stream(target).map(FabRefMap::absoluteMap).collect(Collectors.toList()), cl.getName().replace('.', '/'), mthd.getName(), Type.getMethodDescriptor((Method)mthd), 184, desc, cl.getName()));
                }
            }
            FabInjector.apply(targetClass, toInject);
        }
    }

    public static void lithiumCompat(ClassNode targetClass, String mixinClassName) {
        if (EarlyAgnos.isModLoaded("lithium") && "com.unascribed.fabrication.mixin.e_mechanics.colorful_redstone.MixinRedstoneWireBlock".equals(mixinClassName)) {
            targetClass.methods.forEach(methodNode -> {
                if (methodNode instanceof MethodNodeEx && "getReceivedPowerFaster".equals(((MethodNodeEx)methodNode).getOriginalName())) {
                    methodNode.visibleAnnotations.forEach(annotationNode -> {
                        if (!"Lorg/spongepowered/asm/mixin/transformer/meta/MixinMerged;".equals(annotationNode.desc)) {
                            return;
                        }
                        for (int i = 0; i < annotationNode.values.size(); ++i) {
                            if (!"mixin".equals(annotationNode.values.get(i))) continue;
                            if (++i >= annotationNode.values.size() || !"me.jellysquid.mods.lithium.mixin.block.redstone_wire.RedstoneWireBlockMixin".equals(annotationNode.values.get(i))) break;
                            LabelNode label = new LabelNode(new Label());
                            InsnList earlyRet = new InsnList();
                            earlyRet.add((AbstractInsnNode)new LdcInsnNode((Object)"*.colorful_redstone"));
                            earlyRet.add((AbstractInsnNode)new MethodInsnNode(184, "com/unascribed/fabrication/FabConf", "isEnabled", "(Ljava/lang/String;)Z", false));
                            earlyRet.add((AbstractInsnNode)new JumpInsnNode(153, label));
                            earlyRet.add((AbstractInsnNode)new InsnNode(177));
                            earlyRet.add((AbstractInsnNode)label);
                            methodNode.instructions.insert(earlyRet);
                            break;
                        }
                    });
                }
            });
        }
    }

    public static void finalizeIsEnabled(ClassNode targetClass) {
        targetClass.methods.forEach(methodNode -> {
            for (AbstractInsnNode insnNode : methodNode.instructions) {
                AbstractInsnNode prevInsn;
                MethodInsnNode insn;
                if (!(insnNode instanceof MethodInsnNode) || (insn = (MethodInsnNode)insnNode).getOpcode() != 184 || !"com/unascribed/fabrication/FabConf".equals(insn.owner) || !"(Ljava/lang/String;)Z".equals(insn.desc) || (prevInsn = insn.getPrevious()).getOpcode() != 18) continue;
                Object key = ((LdcInsnNode)prevInsn).cst;
                if ("isEnabled".equals(insn.name)) {
                    methodNode.instructions.insertBefore(prevInsn, (AbstractInsnNode)new InsnNode(FabConf.isEnabled((String)key) ? 4 : 3));
                } else {
                    if (!"isAnyEnabled".equals(insn.name)) continue;
                    methodNode.instructions.insertBefore(prevInsn, (AbstractInsnNode)new InsnNode(FabConf.isAnyEnabled((String)key) ? 4 : 3));
                }
                methodNode.instructions.remove(prevInsn);
                methodNode.instructions.remove((AbstractInsnNode)insn);
                FabLog.debug("Removed IsEnabled Check from : " + targetClass.name + ";" + methodNode.name + methodNode.desc);
            }
        });
    }

    public static Set<String> getConfigKeysForDiscoveredClass(String clazz) {
        return Collections.unmodifiableSet(configKeysForDiscoveredClasses.get((Object)clazz.replace('/', '.')));
    }

    private static interface ClassInfo {
        public String getName();

        public ByteSource asByteSource();
    }

    private static class BareClassInfo
    implements ClassInfo {
        private final String name;
        private final ClassLoader loader;

        public BareClassInfo(String name, ClassLoader loader) {
            this.name = name;
            this.loader = loader;
        }

        @Override
        public String getName() {
            return this.name.replace('/', '.').replace(".class", "");
        }

        @Override
        public ByteSource asByteSource() {
            return Resources.asByteSource((URL)this.loader.getResource(this.name));
        }
    }

    private static class GuavaClassInfo
    implements ClassInfo {
        private final ClassPath.ClassInfo delegate;

        public GuavaClassInfo(ClassPath.ClassInfo delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public ByteSource asByteSource() {
            return this.delegate.asByteSource();
        }
    }
}

