/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.QDIni;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;

public interface ConfigLoader {
    public void load(Path var1, QDIni var2, boolean var3);

    public String getConfigName();

    default public void remove(String key) {
        Stopwatch watch = Stopwatch.createStarted();
        StringWriter sw = new StringWriter();
        Path configFile = EarlyAgnos.getConfigDir().resolve("fabrication").resolve(this.getConfigName() + ".ini");
        try {
            QDIni.loadAndTransform(configFile, QDIni.IniTransformer.simpleLineIniTransformer((path, line) -> {
                if (line == null) {
                    return null;
                }
                int i = line.indexOf(61);
                if (i != -1 && key.equals(path + line.substring(0, i))) {
                    return null;
                }
                return line;
            }), (Writer)sw);
            Files.write(configFile, sw.toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            FabLog.info("Update of " + String.valueOf(configFile) + " done in " + String.valueOf(watch));
        }
        catch (IOException e) {
            FabLog.warn("Failed to update " + String.valueOf(configFile) + " file", e);
        }
    }

    default public void set(final String key, final String val) {
        Stopwatch watch = Stopwatch.createStarted();
        StringWriter sw = new StringWriter();
        Path configFile = EarlyAgnos.getConfigDir().resolve("fabrication").resolve(this.getConfigName() + ".ini");
        try {
            final AtomicBoolean found = new AtomicBoolean(false);
            QDIni.loadAndTransform(configFile, QDIni.IniTransformer.simpleValueIniTransformer((key1, value) -> {
                if (key1.equals(key)) {
                    found.set(true);
                    return val;
                }
                return value;
            }), (Writer)sw);
            if (!found.get()) {
                StringWriter sw2 = new StringWriter();
                QDIni.loadAndTransform(this.getConfigName() + " internal append value", new ByteArrayInputStream(sw.toString().getBytes()), new QDIni.IniTransformer(){
                    boolean insertNext = false;

                    @Override
                    public String transformLine(String path, String line) {
                        if (!found.get()) {
                            if (this.insertNext) {
                                found.set(true);
                                if (line == null) {
                                    return key + "=" + val;
                                }
                                return key + "=" + val + "\n" + line;
                            }
                            if (line != null) {
                                if (line.startsWith("[]")) {
                                    this.insertNext = true;
                                } else if (path != null && !path.isEmpty() && key.startsWith(path)) {
                                    found.set(true);
                                    return key.substring(path.length()) + "=" + val + "\n" + line;
                                }
                            } else {
                                found.set(true);
                                int dot = key.lastIndexOf(46);
                                if (dot == -1) {
                                    return "[]\n" + key + "=" + val;
                                }
                                if (path != null && !path.isEmpty() && key.startsWith(path)) {
                                    return key.substring(path.length()) + "=" + val;
                                }
                                return "[" + key.substring(0, dot) + "]\n" + key.substring(dot + 1) + "=" + val;
                            }
                        }
                        return line;
                    }

                    @Override
                    public String transformValueComment(String key2, String value, String comment) {
                        return comment;
                    }

                    @Override
                    public String transformValue(String key2, String value) {
                        return value;
                    }
                }, (Writer)sw2);
                Files.write(configFile, sw2.toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            } else {
                Files.write(configFile, sw.toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
            FabLog.info("Update of " + String.valueOf(configFile) + " done in " + String.valueOf(watch));
        }
        catch (IOException e) {
            FabLog.warn("Failed to update " + String.valueOf(configFile) + " file", e);
        }
    }
}

