/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.repackage.io.github.queerbric.pride;

import com.google.gson.Gson;
import com.unascribed.fabrication.compat.FabricLoader;
import com.unascribed.fabrication.compat.SimpleResourceReloadListener;
import com.unascribed.fabrication.repackage.io.github.queerbric.pride.PrideFlag;
import com.unascribed.fabrication.repackage.io.github.queerbric.pride.PrideFlags;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;

public class PrideLoader
implements SimpleResourceReloadListener<List<PrideFlag>> {
    private static final ResourceLocation ID = new ResourceLocation("pride", "flags");
    private static final Gson GSON = new Gson();
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("^#[0-9a-fA-F]{6}$");

    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public CompletableFuture<List<PrideFlag>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> PrideLoader.loadFlags(manager));
    }

    @Override
    public CompletableFuture<Void> apply(List<PrideFlag> list, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> PrideLoader.applyFlags(list));
    }

    protected static void firstLoad() {
        PrideLoader.applyFlags(PrideLoader.loadFlags(Minecraft.m_91087_().m_91098_()));
    }

    public static List<PrideFlag> loadFlags(ResourceManager manager) {
        Object parts;
        ArrayList<PrideFlag> flags = new ArrayList<PrideFlag>();
        block36: for (ResourceLocation id : manager.method_14488("flags", path -> path.endsWith(".json"))) {
            parts = id.m_135815_().split("/");
            String name = parts[((String[])parts).length - 1];
            name = name.substring(0, name.length() - 5);
            try {
                InputStreamReader reader = new InputStreamReader(manager.method_14486(id).m_215507_());
                Throwable throwable = null;
                try {
                    PrideFlag.Properties builder = (PrideFlag.Properties)GSON.fromJson((Reader)reader, PrideFlag.Properties.class);
                    for (String color : builder.colors) {
                        if (HEX_COLOR_PATTERN.matcher(color).matches()) continue;
                        LogManager.getLogger((String)"pride").warn("[pride] Malformed flag data for flag " + name + ", " + color + " is not a valid color, must be a six-digit hex color like #FF00FF");
                        continue block36;
                    }
                    PrideFlag flag2 = new PrideFlag(name, builder);
                    flags.add(flag2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Exception e) {
                LogManager.getLogger((String)"pride").warn("[pride] Malformed flag data for flag " + name, (Throwable)e);
            }
        }
        File f = new File(FabricLoader.getInstance().getConfigDir().toFile(), "pride.json");
        if (f.exists()) {
            try {
                FileReader reader = new FileReader(f);
                parts = null;
                try {
                    Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
                    if (config.flags != null) {
                        List<String> list = Arrays.asList(config.flags);
                        flags.removeIf(flag -> !list.contains(flag.getId()));
                    }
                }
                catch (Throwable throwable) {
                    parts = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (parts != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)parts).addSuppressed(throwable);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LogManager.getLogger((String)"pride").warn("[pride] Malformed flag data for pride.json config");
            }
        } else {
            ResourceLocation id;
            id = new ResourceLocation("pride", "flags.json");
            if (manager.method_18234(id)) {
                try (InputStreamReader reader = new InputStreamReader(manager.method_14486(id).m_215507_());){
                    Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
                    if (config.flags != null) {
                        List<String> list = Arrays.asList(config.flags);
                        flags.removeIf(flag -> !list.contains(flag.getId()));
                    }
                }
                catch (Exception e) {
                    LogManager.getLogger((String)"pride").warn("[pride] Malformed flag data for flags.json", (Throwable)e);
                }
            }
        }
        return flags;
    }

    private static void applyFlags(List<PrideFlag> flags) {
        PrideFlags.setFlags(flags);
    }

    class Config {
        String[] flags;

        Config() {
        }
    }
}

