/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.repackage.io.github.queerbric.pride;

import com.mojang.blaze3d.vertex.PoseStack;
import com.unascribed.fabrication.repackage.io.github.queerbric.pride.PrideFlagShape;
import com.unascribed.fabrication.repackage.io.github.queerbric.pride.PrideFlagShapes;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import net.minecraft.resources.ResourceLocation;

public class PrideFlag {
    private String id;
    private PrideFlagShape shape;
    private IntList colors;

    protected PrideFlag(String id, Properties props) {
        this.id = id;
        ResourceLocation shapeId = props.shape == null ? new ResourceLocation("pride", "horizontal_stripes") : (props.shape.contains(":") ? ResourceLocation.m_135820_((String)props.shape) : new ResourceLocation("pride", props.shape));
        this.shape = PrideFlagShapes.get(shapeId);
        if (this.shape == null) {
            throw new IllegalArgumentException("Unknown pride flag shape " + shapeId);
        }
        IntArrayList colorsTmp = new IntArrayList(props.colors.length);
        for (String color : props.colors) {
            colorsTmp.add(Integer.parseInt(color.substring(1), 16) | 0xFF000000);
        }
        this.colors = IntLists.unmodifiable((IntList)colorsTmp);
    }

    public String getId() {
        return this.id;
    }

    public PrideFlagShape getShape() {
        return this.shape;
    }

    public IntList getColors() {
        return this.colors;
    }

    public void render(PoseStack matrices, float x, float y, float width, float height) {
        this.shape.render(this.colors, matrices, x, y, width, height);
    }

    class Properties {
        public String shape;
        public String[] colors;

        Properties() {
        }
    }
}

