/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.g_weird_tweaks.repelling_void;

import com.google.common.collect.Lists;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(configAvailable="*.repelling_void")
@Mixin(value={Player.class})
public abstract class MixinPlayerEntity
extends LivingEntity {
    private Vec3 fabrication$lastGroundPos;
    private BlockPos fabrication$lastLandingPos;
    private final List<Vec3> fabrication$voidFallTrail = Lists.newArrayList();
    private boolean fabrication$debted;

    protected MixinPlayerEntity(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @FabInject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        if (!FabConf.isEnabled("*.repelling_void")) {
            return;
        }
        MixinPlayerEntity entity = this;
        for (Entity vehicle = this.m_20202_(); vehicle != null; vehicle = vehicle.m_20202_()) {
            entity = vehicle;
        }
        if (entity.m_20096_()) {
            this.fabrication$lastGroundPos = entity.m_20182_();
            this.fabrication$lastLandingPos = entity.m_20097_();
            this.fabrication$voidFallTrail.clear();
        } else if (this.fabrication$voidFallTrail.size() < 20) {
            this.fabrication$voidFallTrail.add(this.m_20182_());
        }
        if (this.fabrication$debted) {
            this.fabrication$debted = false;
            this.m_6469_(this.m_9236_().m_269111_().m_269341_(), 12.0f);
        }
    }

    @FabInject(at={@At(value="HEAD")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, cancellable=true)
    public void remove(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (FabConf.isEnabled("*.repelling_void") && !this.fabrication$debted && source.m_276093_(DamageTypes.f_268724_) && this.fabrication$lastLandingPos != null && this.m_20186_() < (double)(this.m_9236_().m_141937_() - 10)) {
            Level world = this.m_9236_();
            BlockPos bp = this.fabrication$lastLandingPos;
            Vec3 pos = this.fabrication$lastGroundPos;
            BlockState state = world.m_8055_(bp);
            if (!state.m_60812_((BlockGetter)world, bp).m_83281_()) {
                AABB bounds = state.m_60812_((BlockGetter)this.m_9236_(), bp).m_83215_();
                pos = new Vec3((double)bp.m_123341_() + bounds.f_82288_ + (bounds.f_82291_ - bounds.f_82288_) / 2.0, (double)bp.m_123342_() + bounds.f_82292_ + 0.1, (double)bp.m_123343_() + bounds.f_82290_ + (bounds.f_82293_ - bounds.f_82290_) / 2.0);
            } else {
                block0: for (int d = 1; d <= 3; ++d) {
                    for (int x = -d; x <= d; ++x) {
                        for (int z = -d; z <= d; ++z) {
                            bp = this.fabrication$lastLandingPos.m_7918_(x, 0, z);
                            state = world.m_8055_(bp);
                            if (state.m_60812_((BlockGetter)world, bp).m_83281_()) continue;
                            AABB bounds = state.m_60812_((BlockGetter)world, bp).m_83215_();
                            pos = new Vec3((double)bp.m_123341_() + bounds.f_82288_ + (bounds.f_82291_ - bounds.f_82288_) / 2.0, (double)bp.m_123342_() + bounds.f_82292_ + 0.1, (double)bp.m_123343_() + bounds.f_82290_ + (bounds.f_82293_ - bounds.f_82290_) / 2.0);
                            break block0;
                        }
                    }
                }
            }
            this.m_6038_();
            this.m_20324_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            this.f_19789_ = 0.0f;
            world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 0.5f);
            world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12350_, SoundSource.PLAYERS, 1.0f, 0.5f);
            world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12350_, SoundSource.PLAYERS, 1.0f, 0.75f);
            world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12558_, SoundSource.PLAYERS, 0.2f, 0.5f);
            MixinPlayerEntity self = this;
            if (!world.f_46443_ && self instanceof ServerPlayer) {
                AABB box = this.m_20191_();
                ((ServerLevel)world).m_8624_((ServerPlayer)self, (ParticleOptions)ParticleTypes.f_123760_, true, pos.f_82479_, pos.f_82480_ + box.m_82376_() / 2.0, pos.f_82481_, 32, box.m_82362_() / 2.0, box.m_82376_() / 2.0, box.m_82385_() / 2.0, 0.2);
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_, pos.f_82480_ + box.m_82376_() / 2.0, pos.f_82481_, 32, box.m_82362_() / 2.0, box.m_82376_() / 2.0, box.m_82385_() / 2.0, 0.2);
                for (Vec3 vec : this.fabrication$voidFallTrail) {
                    ((ServerLevel)world).m_8624_((ServerPlayer)self, (ParticleOptions)ParticleTypes.f_123796_, true, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0, 0.0, 1.0, 0.0, 0.05);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123796_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0, 0.0, 1.0, 0.0, 0.05);
                }
            }
            if (!(self instanceof Player) || !((Player)self).m_150110_().f_35934_) {
                this.fabrication$debted = true;
            }
            cir.setReturnValue((Object)false);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void writeCustomDataToTag(CompoundTag tag, CallbackInfo ci) {
        if (this.fabrication$lastGroundPos != null) {
            Vec3 pos = this.fabrication$lastGroundPos;
            tag.m_128347_("fabrication:LastGroundPosX", pos.f_82479_);
            tag.m_128347_("fabrication:LastGroundPosY", pos.f_82480_);
            tag.m_128347_("fabrication:LastGroundPosZ", pos.f_82481_);
        }
        if (this.fabrication$debted) {
            tag.m_128379_("fabrication:Debted", this.fabrication$debted);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void readCustomDataFromTag(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("fabrication:LastGroundPosX")) {
            this.fabrication$lastGroundPos = new Vec3(tag.m_128459_("fabrication:LastGroundPosX"), tag.m_128459_("fabrication:LastGroundPosY"), tag.m_128459_("fabrication:LastGroundPosZ"));
        }
        this.fabrication$debted = tag.m_128471_("fabrication:Debted");
    }
}

