/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.c_tweaks.permanent_conduit_power;

import com.mojang.authlib.GameProfile;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import com.unascribed.fabrication.util.EffectNeedsReplacing;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(configAvailable="*.permanent_conduit_power")
@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayerEntity
extends Player {
    private boolean fabrication$permConduitPower;
    private static final Predicate<Player> fabrication$permanentConduitPowerPredicate = ConfigPredicates.getFinalPredicate("*.permanent_conduit_power");

    public MixinServerPlayerEntity(MinecraftServer pos, ServerLevel yaw, GameProfile gameProfile) {
        MixinServerPlayerEntity mixinServerPlayerEntity = this;
        super(pos, yaw, gameProfile);
        this.fabrication$permConduitPower = false;
    }

    @FabInject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        if (FabConf.isEnabled("*.permanent_conduit_power") && fabrication$permanentConduitPowerPredicate.test(this)) {
            if (!this.fabrication$permConduitPower) {
                this.fabrication$permConduitPower = true;
            }
            if (EffectNeedsReplacing.needsReplacing(this, MobEffects.f_19592_)) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19592_, Integer.MAX_VALUE, 0, true, false));
            }
        } else if (this.fabrication$permConduitPower) {
            this.fabrication$permConduitPower = false;
            this.m_21195_(MobEffects.f_19592_);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void writeCustomDataToTag(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("fabrication:permanent_conduit_power", this.fabrication$permConduitPower);
    }

    @FabInject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void readCustomDataFromTag(CompoundTag tag, CallbackInfo ci) {
        this.fabrication$permConduitPower = tag.m_128471_("fabrication:permanent_conduit_power");
    }
}

