/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.c_tweaks.less_restrictive_note_blocks;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.FailOn;
import com.unascribed.fabrication.support.SpecialEligibility;
import com.unascribed.fabrication.support.injection.FabInject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(configAvailable="*.less_restrictive_note_blocks")
@FailOn(invertedSpecialConditions={SpecialEligibility.NOT_FORGE})
@Mixin(value={NoteBlock.class})
public abstract class MixinNoteBlock
extends Block {
    public MixinNoteBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @FabInject(method={"playNote(Lnet/minecraft/entity/Entity;Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void playNote(Entity entity, BlockState s1, Level world, BlockPos pos, CallbackInfo ci) {
        Direction[] directions;
        if (!FabConf.isEnabled("*.less_restrictive_note_blocks")) {
            return;
        }
        for (Direction dir : directions = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.DOWN}) {
            BlockPos op = pos.m_121945_(dir);
            BlockState bs = world.m_8055_(op);
            if (bs.m_60783_((BlockGetter)world, op, dir.m_122424_())) continue;
            BlockState state = world.m_8055_(pos);
            int note = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
            float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
            world.m_5594_(null, pos, (SoundEvent)((NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_)).m_263188_().m_203334_(), SoundSource.RECORDS, 3.0f, pitch);
            double pX = (double)pos.m_123341_() + 0.5 + (double)dir.m_122429_() * 0.7;
            double pY = (double)pos.m_123342_() + 0.5 + (double)dir.m_122430_() * 0.7;
            double pZ = (double)pos.m_123343_() + 0.5 + (double)dir.m_122431_() * 0.7;
            if (world.f_46443_) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, pX, pY, pZ, (double)note / 24.0, 0.0, 0.0);
            } else {
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123758_, pX, pY, pZ, 0, (double)note / 24.0, 0.0, (double)(dir.ordinal() - 1), 1.0);
            }
            world.m_142346_(entity, GameEvent.f_223699_, pos);
            break;
        }
        ci.cancel();
    }
}

