/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.c_tweaks.invisible_to_mobs;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(anyConfigAvailable={"*.no_phantoms", "*.invisible_to_mobs"})
@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    private static final Predicate<Player> fabrication$noPhantomsPredicate = ConfigPredicates.getFinalPredicate("*.no_phantoms");
    private static final Predicate<Player> fabrication$invisMobsPredicate = ConfigPredicates.getFinalPredicate("*.invisible_to_mobs");

    protected MixinLivingEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
    }

    @FabInject(at={@At(value="HEAD")}, method={"canTarget(Lnet/minecraft/entity/LivingEntity;)Z"}, cancellable=true)
    public void canTarget(LivingEntity other, CallbackInfoReturnable<Boolean> ci) {
        if (!(other instanceof Player)) {
            return;
        }
        if (FabConf.isEnabled("*.no_phantoms") && this instanceof Phantom && fabrication$noPhantomsPredicate.test((Player)other)) {
            ci.setReturnValue((Object)false);
        }
        if (FabConf.isEnabled("*.invisible_to_mobs") && fabrication$invisMobsPredicate.test((Player)other)) {
            ci.setReturnValue((Object)false);
        }
    }
}

