/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.b_utility.taggable_players;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.features.FeatureTaggablePlayers;
import com.unascribed.fabrication.interfaces.TaggablePlayer;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(configAvailable="*.taggable_players")
@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayerEntity
extends Player
implements TaggablePlayer {
    private final Set<String> fabrication$tags;
    private Map<String, Boolean> fabrication$tagsOverride;

    public MixinServerPlayerEntity(MinecraftServer pos, ServerLevel yaw, GameProfile gameProfile) {
        MixinServerPlayerEntity mixinServerPlayerEntity = this;
        super(pos, yaw, gameProfile);
        this.fabrication$tags = new HashSet<String>();
        this.fabrication$tagsOverride = null;
    }

    @Override
    public Set<String> fabrication$getTags() {
        return ImmutableSet.copyOf(this.fabrication$tags);
    }

    @Override
    public void fabrication$clearTags() {
        this.fabrication$tags.clear();
    }

    @Override
    public void fabrication$setTag(String tag, boolean enabled) {
        if (enabled) {
            this.fabrication$tags.add(tag);
        } else {
            this.fabrication$tags.remove(tag);
        }
    }

    @Override
    public boolean fabrication$hasTag(String tag) {
        Boolean b;
        if (this.fabrication$tagsOverride != null && (b = this.fabrication$tagsOverride.get(tag)) != null) {
            return b;
        }
        return this.fabrication$tags.contains(tag);
    }

    @Override
    public Boolean fabrication$getTagOverride(String tag) {
        if (this.fabrication$tagsOverride == null) {
            return null;
        }
        return this.fabrication$tagsOverride.get(tag);
    }

    @FabInject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/world/ServerWorld;Lcom/mojang/authlib/GameProfile;)V"})
    public void fabrication$genOverride(MinecraftServer server, ServerLevel world, GameProfile profile, CallbackInfo ci) {
        Map<String, Boolean> mapName = FeatureTaggablePlayers.playerNameOverrideMap.get(profile.getName());
        Map<String, Boolean> mapUuid = FeatureTaggablePlayers.playerUUIDOverrideMap.get(profile.getId());
        if (mapUuid != null || mapName != null) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            if (mapName != null) {
                map.putAll(mapName);
            }
            if (mapUuid != null) {
                map.putAll(mapUuid);
            }
            this.fabrication$tagsOverride = map;
        }
    }

    @FabInject(at={@At(value="HEAD")}, method={"copyFrom(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V"})
    public void copyFrom(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        this.fabrication$tags.clear();
        this.fabrication$tags.addAll(((TaggablePlayer)oldPlayer).fabrication$getTags());
    }

    @FabInject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void writeCustomDataToTag(CompoundTag tag, CallbackInfo ci) {
        ListTag li = new ListTag();
        for (String pt : this.fabrication$tags) {
            li.add((Object)StringTag.m_129297_((String)pt));
        }
        if (!li.isEmpty()) {
            tag.m_128365_("fabrication:Tags", (Tag)li);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void readCustomDataFromTag(CompoundTag tag, CallbackInfo ci) {
        this.fabrication$tags.clear();
        ListTag li = tag.m_128437_("fabrication:Tags", 8);
        for (int i = 0; i < li.size(); ++i) {
            String key = li.m_128778_(i);
            String fullKey = FabConf.remap("*." + key.toLowerCase(Locale.ROOT));
            if (!FeatureTaggablePlayers.activeTags.containsKey(fullKey)) {
                FabLog.warn("TaggablePlayers added " + fullKey + " as a valid option because a player was tagged with it");
                FeatureTaggablePlayers.add(fullKey, 0);
            }
            this.fabrication$tags.add(key);
        }
    }
}

