/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.b_utility.item_despawn;

import com.google.common.primitives.Ints;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.interfaces.ItemDespawn;
import com.unascribed.fabrication.interfaces.SetFromPlayerDeath;
import com.unascribed.fabrication.loaders.LoaderItemDespawn;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import com.unascribed.fabrication.support.injection.ModifyGetField;
import com.unascribed.fabrication.util.ParsedTime;
import com.unascribed.fabrication.util.Resolvable;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(configAvailable="*.item_despawn")
@Mixin(value={ItemEntity.class})
public abstract class MixinItemEntity
extends Entity
implements SetFromPlayerDeath,
ItemDespawn {
    private long fabrication$trueAge;
    private int fabrication$extraTime;
    private boolean fabrication$invincible;
    private boolean fabrication$fromPlayerDeath;
    @Shadow
    private int f_31985_;
    @Shadow
    private UUID f_31988_;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public MixinItemEntity(ItemEntity world) {
        MixinItemEntity mixinItemEntity = this;
        super(world);
    }

    @Shadow
    public abstract ItemStack m_32055_();

    @FabInject(at={@At(value="HEAD")}, method={"tick()V"})
    public void tickHead(CallbackInfo ci) {
        if (this.fabrication$extraTime > 0) {
            --this.fabrication$extraTime;
            --this.f_31985_;
        }
        ++this.fabrication$trueAge;
        int worldBottom = this.m_9236_().m_141937_();
        if (this.m_20182_().f_82480_ < (double)(worldBottom - 32) && this.fabrication$invincible) {
            this.m_20324_(this.m_20182_().f_82479_, worldBottom + 1, this.m_20182_().f_82481_);
            this.m_20334_(0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                ((ServerLevel)this.m_9236_()).m_7726_().m_8394_((Entity)this, (Packet)new ClientboundTeleportEntityPacket((Entity)this));
                ((ServerLevel)this.m_9236_()).m_7726_().m_8394_((Entity)this, (Packet)new ClientboundSetEntityMotionPacket((Entity)this));
            }
        }
    }

    @FabInject(at={@At(value="HEAD")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, cancellable=true)
    public void damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> ci) {
        if (this.fabrication$invincible || FabConf.isEnabled("*.item_despawn") && this.m_9236_().f_46443_) {
            ci.setReturnValue((Object)false);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"setStack(Lnet/minecraft/item/ItemStack;)V"})
    public void setStack(ItemStack stack, CallbackInfo ci) {
        this.calculateDespawn();
    }

    @FabInject(at={@At(value="TAIL")}, method={"setThrower(Ljava/util/UUID;)V"})
    public void setThrower(UUID id, CallbackInfo ci) {
        this.calculateDespawn();
    }

    @ModifyGetField(target={"net/minecraft/entity/ItemEntity.itemAge:I"}, method={"canMerge()Z"})
    private static int fabrication$modifyIllegalAge(int orig, ItemEntity item) {
        return item instanceof ItemDespawn && ((ItemDespawn)item).fabrication$itemDespawn$invinc() ? orig - 1 : orig;
    }

    @Override
    public boolean fabrication$itemDespawn$invinc() {
        return this.fabrication$invincible;
    }

    @Override
    public void fabrication$setFromPlayerDeath(boolean b) {
        this.fabrication$fromPlayerDeath = b;
        this.calculateDespawn();
    }

    @Unique
    private void calculateDespawn() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        boolean debug = false;
        ItemStack stack = this.m_32055_();
        ParsedTime time = LoaderItemDespawn.itemDespawns.get(Resolvable.mapKey(stack.m_41720_(), BuiltInRegistries.f_257033_));
        if (time == null) {
            time = ParsedTime.Unset.NORMAL;
        }
        if (!time.priority) {
            for (Enchantment enchantment : EnchantmentHelper.m_44831_((ItemStack)stack).keySet()) {
                ParsedTime enchTime;
                if (enchantment.m_6589_()) {
                    if (LoaderItemDespawn.curseDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.curseDespawn;
                    }
                } else {
                    if (LoaderItemDespawn.normalEnchDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.normalEnchDespawn;
                    }
                    if (enchantment.m_6591_() && LoaderItemDespawn.treasureDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.treasureDespawn;
                    }
                }
                if ((enchTime = LoaderItemDespawn.enchDespawns.get(Resolvable.mapKey(enchantment, BuiltInRegistries.f_256876_))) == null || !enchTime.overshadows(time)) continue;
                time = enchTime;
            }
            for (Map.Entry entry : LoaderItemDespawn.tagDespawns.entrySet()) {
                TagKey itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)((ResourceLocation)entry.getKey()));
                if (stack.m_204117_(itemTag) && ((ParsedTime)entry.getValue()).overshadows(time)) {
                    time = (ParsedTime)entry.getValue();
                }
                if (!(stack.m_41720_() instanceof BlockItem)) continue;
                BlockItem bi = (BlockItem)stack.m_41720_();
                TagKey blockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)((ResourceLocation)entry.getKey()));
                if (!bi.m_40614_().m_204297_().m_203656_(blockTag) || !((ParsedTime)entry.getValue()).overshadows(time)) continue;
                time = (ParsedTime)entry.getValue();
            }
            if (stack.m_41782_()) {
                if (stack.m_41788_() && LoaderItemDespawn.renamedDespawn.overshadows(time)) {
                    time = LoaderItemDespawn.renamedDespawn;
                }
                for (Map.Entry entry : LoaderItemDespawn.nbtBools.entrySet()) {
                    if (!stack.m_41783_().m_128471_((String)entry.getKey()) || !((ParsedTime)entry.getValue()).overshadows(time)) continue;
                    time = (ParsedTime)entry.getValue();
                }
            }
        }
        if (this.fabrication$fromPlayerDeath && LoaderItemDespawn.playerDeathDespawn.overshadows(time)) {
            time = LoaderItemDespawn.playerDeathDespawn;
        }
        if (time instanceof ParsedTime.Unset) {
            time = this.f_31988_ == null ? LoaderItemDespawn.dropsDespawn : LoaderItemDespawn.defaultDespawn;
        }
        this.fabrication$invincible = false;
        if (time instanceof ParsedTime.Forever) {
            this.fabrication$extraTime = 0;
            this.f_31985_ = Short.MIN_VALUE;
        } else if (time instanceof ParsedTime.Invincible) {
            this.fabrication$extraTime = 0;
            this.f_31985_ = Short.MIN_VALUE;
            this.fabrication$invincible = true;
        } else if (time instanceof ParsedTime.Instant) {
            this.m_146870_();
        } else if (time instanceof ParsedTime.Unset) {
            this.fabrication$extraTime = 0;
        } else {
            int extra = time.timeInTicks - 6000;
            if ((extra -= Ints.saturatedCast((long)this.fabrication$trueAge)) < 0) {
                this.f_31985_ = -extra;
                this.fabrication$extraTime = 0;
            } else {
                this.f_31985_ = 0;
                this.fabrication$extraTime = extra;
            }
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void writeCustomDataToTag(CompoundTag tag, CallbackInfo ci) {
        if (this.fabrication$extraTime > 0) {
            tag.m_128405_("fabrication:ExtraTime", this.fabrication$extraTime);
        }
        tag.m_128356_("fabrication:TrueAge", this.fabrication$trueAge);
        if (this.fabrication$fromPlayerDeath) {
            tag.m_128379_("fabrication:FromPlayerDeath", true);
        }
        if (this.fabrication$invincible) {
            tag.m_128379_("fabrication:Invincible", true);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void readCustomDataFromTag(CompoundTag tag, CallbackInfo ci) {
        this.fabrication$extraTime = tag.m_128451_("fabrication:ExtraTime");
        this.fabrication$trueAge = tag.m_128454_("fabrication:TrueAge");
        this.fabrication$fromPlayerDeath = tag.m_128471_("fabrication:FromPlayerDeath");
        this.fabrication$invincible = tag.m_128471_("fabrication:Invincible");
    }
}

