/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.logic;

import com.google.common.collect.ImmutableSet;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class WaterFillsOnBreak {
    private static final ImmutableSet<Direction> CHECK_DIRECTIONS = ImmutableSet.of((Object)Direction.UP, (Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.SOUTH, (Object)Direction.WEST);

    public static FlowingFluid shouldFill(Level world, BlockPos pos) {
        int countWater = 0;
        int countAir = 0;
        FlowingFluid retFluid = null;
        BlockPos lastWater = null;
        for (Direction d : CHECK_DIRECTIONS) {
            BlockState bs;
            BlockPos p = pos.m_121945_(d);
            FluidState fluidState = world.m_6425_(p);
            Fluid fluid = fluidState.m_76152_();
            if (fluidState.m_76170_()) {
                if (!(fluid instanceof FlowingFluid) || !FabRefl.isInfinate((FlowingFluid)fluid, world)) continue;
                if (retFluid == null) {
                    retFluid = (FlowingFluid)fluid;
                } else if (!fluid.m_6212_((Fluid)retFluid)) continue;
                lastWater = p;
                ++countWater;
                continue;
            }
            if (d == Direction.UP || !(bs = world.m_8055_(p)).m_60795_()) continue;
            ++countAir;
        }
        if (!FabConf.isEnabled("*.water_fills_on_break_strict") || countWater != 1) {
            return countWater > countAir ? retFluid : null;
        }
        for (Direction d : Direction.values()) {
            FluidState fluidState = world.m_6425_(lastWater.m_121945_(d));
            Fluid fluid = fluidState.m_76152_();
            if (!fluidState.m_76170_() || !fluid.m_6212_((Fluid)retFluid)) continue;
            return retFluid;
        }
        return null;
    }
}

