/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Feature;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;

@EligibleIf(configAvailable="*.invisible_to_mobs")
public class FeatureInvisibleToMobs
implements Feature {
    private Predicate<Entity> originalUntargetablePredicate;

    @Override
    public void apply() {
        this.originalUntargetablePredicate = EntitySelector.f_20406_;
        Predicate predicate = ConfigPredicates.getFinalPredicate("*.invisible_to_mobs");
        this.amendUntargetablePredicate(e -> {
            if (e instanceof Player && predicate.test((Player)e)) {
                return false;
            }
            return this.originalUntargetablePredicate.test((Entity)e);
        });
    }

    private void amendUntargetablePredicate(Predicate<Entity> p) {
        EntitySelector.f_20406_ = p;
    }

    @Override
    public boolean undo() {
        if (this.originalUntargetablePredicate != null) {
            this.amendUntargetablePredicate(this.originalUntargetablePredicate);
        }
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.invisible_to_mobs";
    }
}

