/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.unascribed.ears.api.EarsStateType;
import com.unascribed.ears.api.OverrideResult;
import com.unascribed.ears.api.registry.EarsStateOverriderRegistry;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.interfaces.GetSuppressedSlots;
import com.unascribed.fabrication.interfaces.SetFabricationConfigAware;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

@EligibleIf(configAvailable="*.hide_armor")
public class FeatureHideArmor
implements Feature {
    private static final EquipmentSlot[] ALL_ARMOR = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    private boolean applied = false;
    private boolean registered = false;

    @Override
    public void apply() {
        this.applied = true;
        if (!this.registered) {
            this.registered = true;
            Agnos.runForCommandRegistration((dispatcher, registryAccess, dedi) -> {
                dispatcher.register(this.buildCommand("hidearmor", true));
                dispatcher.register(this.buildCommand("showarmor", false));
            });
            if (EarlyAgnos.getCurrentEnv() == Env.CLIENT && EarlyAgnos.isModLoaded("ears")) {
                try {
                    EarsCompat.init();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private LiteralArgumentBuilder<CommandSourceStack> buildCommand(String cmd, boolean hidden) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)cmd).requires(scs -> FabConf.isEnabled("*.hide_armor") && this.applied)).then(Commands.m_82127_((String)"all").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, ALL_ARMOR)))).then(Commands.m_82127_((String)"head").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, EquipmentSlot.HEAD)))).then(Commands.m_82127_((String)"chest").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, EquipmentSlot.CHEST)))).then(Commands.m_82127_((String)"legs").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, EquipmentSlot.LEGS)))).then(Commands.m_82127_((String)"feet").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, EquipmentSlot.FEET)))).then(Commands.m_82127_((String)"!head").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)))).then(Commands.m_82127_((String)"!chest").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, EquipmentSlot.HEAD, EquipmentSlot.LEGS, EquipmentSlot.FEET)))).then(Commands.m_82127_((String)"!legs").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, EquipmentSlot.CHEST, EquipmentSlot.HEAD, EquipmentSlot.FEET)))).then(Commands.m_82127_((String)"!feet").executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.HEAD)))).executes(c -> this.setArmorHidden((CommandContext<CommandSourceStack>)c, hidden, ALL_ARMOR));
    }

    private int setArmorHidden(CommandContext<CommandSourceStack> c, boolean hidden, EquipmentSlot ... slots) throws CommandSyntaxException {
        ServerPlayer ent = ((CommandSourceStack)c.getSource()).m_81375_();
        if (ent instanceof GetSuppressedSlots) {
            String verb;
            Set<EquipmentSlot> suppressed = ((GetSuppressedSlots)ent).fabrication$getSuppressedSlots();
            int amt = 0;
            for (EquipmentSlot es : slots) {
                if (hidden) {
                    if (!suppressed.add(es)) continue;
                    ++amt;
                    continue;
                }
                if (!suppressed.remove(es)) continue;
                ++amt;
            }
            ArrayList li = Lists.newArrayList();
            for (EquipmentSlot es : EquipmentSlot.values()) {
                li.add(Pair.of((Object)es, (Object)(suppressed.contains(es) ? ItemStack.f_41583_ : ent.m_6844_(es))));
            }
            ((ServerLevel)ent.m_9236_()).m_7726_().m_8445_((Entity)ent, (Packet)new ClientboundSetEquipmentPacket(ent.m_19879_(), (List)li));
            FeatureHideArmor.sendSuppressedSlotsForSelf(ent);
            String string = verb = hidden ? "hidden" : "shown";
            if (amt == 4) {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("All armor slots " + verb)), false);
            } else if (amt > 1) {
                int aamt = amt;
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)(aamt + " armor slots " + verb)), false);
            } else if (amt > 0) {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("1 armor slot " + verb)), false);
            } else {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("All specified slots are already " + verb)), false);
            }
        } else {
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Patch error!"), false);
        }
        return 1;
    }

    @Override
    public boolean undo() {
        this.applied = false;
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.hide_armor";
    }

    public static List<Pair<EquipmentSlot, ItemStack>> muddle(Entity entity, List<Pair<EquipmentSlot, ItemStack>> equipmentList) {
        if (FabConf.isEnabled("*.hide_armor") && entity instanceof GetSuppressedSlots) {
            Set<EquipmentSlot> slots = ((GetSuppressedSlots)entity).fabrication$getSuppressedSlots();
            return Lists.transform(equipmentList, pair -> slots.contains(pair.getFirst()) ? Pair.of((Object)((EquipmentSlot)pair.getFirst()), (Object)ItemStack.f_41583_) : pair);
        }
        return equipmentList;
    }

    public static void sendSuppressedSlotsForSelf(ServerPlayer ent) {
        if (ent instanceof SetFabricationConfigAware && ((SetFabricationConfigAware)ent).fabrication$getReqVer() >= 0) {
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            int bits = 0;
            for (EquipmentSlot es : ((GetSuppressedSlots)ent).fabrication$getSuppressedSlots()) {
                bits |= 1 << es.m_20749_();
            }
            data.m_130130_(bits);
            ClientboundCustomPayloadPacket pkt = new ClientboundCustomPayloadPacket(new ResourceLocation("fabrication", "hide_armor"), data);
            ent.f_8906_.m_9829_((Packet)pkt);
        }
    }

    private static final class EarsCompat {
        private EarsCompat() {
        }

        public static void init() {
            EarsStateOverriderRegistry.register((String)"fabrication", (state, peer) -> {
                if (!FabConf.isEnabled("*.hide_armor")) {
                    return OverrideResult.DEFAULT;
                }
                if (!(peer instanceof GetSuppressedSlots)) {
                    return OverrideResult.DEFAULT;
                }
                GetSuppressedSlots gsg = (GetSuppressedSlots)peer;
                if (state == EarsStateType.WEARING_HELMET && gsg.fabrication$getSuppressedSlots().contains(EquipmentSlot.HEAD)) {
                    return OverrideResult.FALSE;
                }
                if (state == EarsStateType.WEARING_CHESTPLATE && gsg.fabrication$getSuppressedSlots().contains(EquipmentSlot.CHEST)) {
                    return OverrideResult.FALSE;
                }
                if (state == EarsStateType.WEARING_LEGGINGS && gsg.fabrication$getSuppressedSlots().contains(EquipmentSlot.LEGS)) {
                    return OverrideResult.FALSE;
                }
                if (state == EarsStateType.WEARING_BOOTS && gsg.fabrication$getSuppressedSlots().contains(EquipmentSlot.FEET)) {
                    return OverrideResult.FALSE;
                }
                return OverrideResult.DEFAULT;
            });
        }
    }
}

