/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.unascribed.fabrication.FabLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class QDIni {
    private final String prelude;
    private final Map<String, List<BlameString>> data;
    private Consumer<String> yapLog = FabLog::warn;

    private QDIni(String prelude, Map<String, List<BlameString>> data) {
        this.prelude = prelude;
        this.data = data;
    }

    public void setYapLog(Consumer<String> yapLog) {
        this.yapLog = yapLog;
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key) && !this.data.get(key).isEmpty();
    }

    public void put(String key, String value) {
        ArrayList<BlameString> li = new ArrayList<BlameString>();
        li.add(new BlameString(value));
        this.data.put(key, li);
    }

    public void put(String key, String ... values) {
        ArrayList<BlameString> li = new ArrayList<BlameString>();
        for (String v : values) {
            li.add(new BlameString(v));
        }
        this.data.put(key, li);
    }

    public void put(String key, Iterable<String> values) {
        ArrayList<BlameString> li = new ArrayList<BlameString>();
        for (String v : values) {
            li.add(new BlameString(v));
        }
        this.data.put(key, li);
    }

    public List<String> getAll(String key) {
        return this.unwrap(this.data.get(key));
    }

    private List<BlameString> getAllBlamed(String key) {
        return this.data.containsKey(key) ? this.data.get(key) : Collections.emptyList();
    }

    public String getBlame(String key) {
        return this.getBlamed(key).map(BlameString::blame).orElse("<unknown>");
    }

    public String getBlame(String key, int index) {
        if (this.containsKey(key)) {
            return this.getAllBlamed(key).get(index).blame();
        }
        return "<unknown>";
    }

    private List<String> unwrap(final List<BlameString> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return QDIni.this.unwrap((BlameString)list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    private String unwrap(BlameString bs) {
        if (bs == null) {
            return null;
        }
        return bs.value;
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.getLast(this.getAll(key)));
    }

    private Optional<BlameString> getBlamed(String key) {
        return Optional.ofNullable(this.getLast(this.getAllBlamed(key)));
    }

    public Optional<Integer> getInt(String key) throws BadValueException {
        return this.getParsed(key, Integer::parseInt, () -> "a whole number");
    }

    public Optional<Double> getDouble(String key) throws BadValueException {
        return this.getParsed(key, Double::parseDouble, () -> "a number");
    }

    public Optional<Boolean> getBoolean(String key) throws BadValueException {
        return this.getParsed(key, this::strictParseBoolean, () -> "true or false");
    }

    private boolean strictParseBoolean(String s) {
        switch (s.toLowerCase(Locale.ROOT)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    public <E extends Enum<E>> Optional<E> getEnum(String key, Class<E> clazz) throws BadValueException {
        return this.getParsed(key, s -> Enum.valueOf(clazz, s.toUpperCase(Locale.ROOT)), () -> {
            StringBuilder sb = new StringBuilder("one of ");
            boolean first = true;
            for (Enum e : (Enum[])clazz.getEnumConstants()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(e.name().toLowerCase(Locale.ROOT));
            }
            return sb.toString();
        });
    }

    private <T> Optional<T> getParsed(String key, Function<String, ? extends T> parser, Supplier<String> error) throws BadValueException {
        Optional<String> s = this.get(key);
        if (!s.isPresent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(parser.apply(s.get()));
        }
        catch (IllegalArgumentException e) {
            String msg = key + " must be " + error.get() + " (got " + s.get() + ") at " + this.getBlame(key);
            if (this.yapLog != null) {
                this.yapLog.accept(msg);
                return Optional.empty();
            }
            throw new BadValueException(msg, e);
        }
    }

    private <T> T getLast(List<T> list) {
        return list == null || list.isEmpty() ? null : (T)list.get(list.size() - 1);
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                final Iterator<Map.Entry<String, List<BlameString>>> delegate = QDIni.this.data.entrySet().iterator();
                return new Iterator<Map.Entry<String, List<String>>>(){

                    @Override
                    public boolean hasNext() {
                        return delegate.hasNext();
                    }

                    @Override
                    public Map.Entry<String, List<String>> next() {
                        Map.Entry den = (Map.Entry)delegate.next();
                        return new AbstractMap.SimpleImmutableEntry<String, List<String>>((String)den.getKey(), QDIni.this.unwrap((List)den.getValue()));
                    }
                };
            }

            @Override
            public int size() {
                return this.size();
            }
        };
    }

    public int size() {
        return this.data.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("; Loaded from ");
        sb.append(this.prelude);
        sb.append("\r\n");
        for (Map.Entry<String, List<String>> en : this.entrySet()) {
            for (String v : en.getValue()) {
                sb.append(en.getKey());
                sb.append("=");
                sb.append(v);
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    public QDIni merge(QDIni that) {
        LinkedHashMap newData = new LinkedHashMap(Math.max(this.size(), that.size()));
        newData.putAll(this.data);
        for (Map.Entry<String, List<BlameString>> en : that.data.entrySet()) {
            if (newData.containsKey(en.getKey())) {
                ArrayList merged = new ArrayList(((List)newData.get(en.getKey())).size() + en.getValue().size());
                merged.addAll((Collection)newData.get(en.getKey()));
                merged.addAll(en.getValue());
                newData.put(en.getKey(), Collections.unmodifiableList(merged));
                continue;
            }
            newData.put(en.getKey(), en.getValue());
        }
        return new QDIni(this.prelude + ", merged with " + that.prelude, Collections.unmodifiableMap(newData));
    }

    public Map<String, String> flatten() {
        return new AbstractMap<String, String>(){

            @Override
            public String get(Object key) {
                return QDIni.this.get((String)key).orElse(null);
            }

            @Override
            public boolean containsKey(Object key) {
                return QDIni.this.containsKey((String)key);
            }

            @Override
            public Set<String> keySet() {
                return QDIni.this.keySet();
            }

            @Override
            public int size() {
                return QDIni.this.size();
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return new AbstractSet<Map.Entry<String, String>>(){

                    @Override
                    public Iterator<Map.Entry<String, String>> iterator() {
                        final Iterator<Map.Entry<String, List<String>>> delegate = QDIni.this.entrySet().iterator();
                        return new Iterator<Map.Entry<String, String>>(){

                            @Override
                            public boolean hasNext() {
                                return delegate.hasNext();
                            }

                            @Override
                            public Map.Entry<String, String> next() {
                                Map.Entry den = (Map.Entry)delegate.next();
                                return new AbstractMap.SimpleImmutableEntry<String, String>((String)den.getKey(), (String)QDIni.this.getLast((List)den.getValue()));
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return this.size();
                    }
                };
            }
        };
    }

    public static QDIni load(String fileName, String s) {
        try {
            return QDIni.load(fileName, new StringReader(s));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static QDIni load(File f) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            QDIni qDIni = QDIni.load(f.getName(), in);
            return qDIni;
        }
    }

    public static QDIni load(Path p) throws IOException {
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            QDIni qDIni = QDIni.load(p.getFileName().toString(), in);
            return qDIni;
        }
    }

    public static QDIni load(String fileName, InputStream in) throws IOException {
        return QDIni.load(fileName, new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public static QDIni load(String fileName, Reader r) throws IOException {
        return QDIni.loadAndTransform(fileName, r, null, null);
    }

    public static QDIni loadAndTransform(String fileName, String s, IniTransformer transformer, Writer w) {
        try {
            return QDIni.loadAndTransform(fileName, new StringReader(s), transformer, w);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static QDIni loadAndTransform(File f, IniTransformer transformer, Writer w) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            QDIni qDIni = QDIni.loadAndTransform(f.getName(), in, transformer, w);
            return qDIni;
        }
    }

    public static QDIni loadAndTransform(Path p, IniTransformer transformer, Writer w) throws IOException {
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            QDIni qDIni = QDIni.loadAndTransform(p.getFileName().toString(), in, transformer, w);
            return qDIni;
        }
    }

    public static QDIni loadAndTransform(String fileName, InputStream in, IniTransformer transformer, Writer w) throws IOException {
        return QDIni.loadAndTransform(fileName, new InputStreamReader(in, StandardCharsets.UTF_8), transformer, w);
    }

    public static QDIni loadAndTransform(String fileName, Reader r, IniTransformer transformer, Writer w) throws IOException, SyntaxErrorException {
        return QDIni.loadAndTransform(fileName, r, transformer, w, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QDIni loadAndTransform(String fileName, Reader r, IniTransformer transformer, Writer w, boolean inValComments) throws IOException, SyntaxErrorException {
        BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        LinkedHashMap<String, List<BlameString>> data = new LinkedHashMap<String, List<BlameString>>();
        int lineNum = 1;
        Object path = "";
        while (true) {
            Object line = br.readLine();
            if (transformer != null) {
                boolean eof = line == null;
                if ((line = transformer.transformLine((String)path, (String)line)) == null) {
                    if (!eof) continue;
                    return new QDIni(fileName, data);
                }
                if (eof) {
                    if (w == null) return new QDIni(fileName, data);
                    w.write((String)line);
                    w.write("\r\n");
                    return new QDIni(fileName, data);
                }
            }
            if (line == null) return new QDIni(fileName, data);
            String trunc = ((String)line).trim();
            if (trunc.startsWith(";") || trunc.isEmpty()) {
                if (w != null) {
                    w.write((String)line);
                    w.write("\r\n");
                }
                ++lineNum;
                continue;
            }
            if (((String)line).startsWith("[")) {
                if (((String)line).contains(";") && inValComments) {
                    trunc = ((String)line).substring(0, ((String)line).indexOf(59));
                }
                if (!(trunc = trunc.trim()).endsWith("]")) throw new SyntaxErrorException("Malformed section header at line " + lineNum + " in " + fileName);
                path = trunc.substring(1, trunc.length() - 1);
                if (((String)path).contains("[") || ((String)path).contains("]")) {
                    throw new SyntaxErrorException("Malformed section header at line " + lineNum + " in " + fileName);
                }
                if (!(((String)path).isEmpty() || ((String)path).endsWith(":") || ((String)path).endsWith("."))) {
                    path = (String)path + ".";
                }
            } else {
                if (!((String)line).contains("=")) throw new SyntaxErrorException("Couldn't find a section, comment, or key-value assigment at line " + lineNum + " in " + fileName);
                String comment = null;
                if (trunc.contains(";") && inValComments) {
                    comment = trunc.substring(trunc.indexOf(59) + 1);
                    trunc = trunc.substring(0, trunc.indexOf(59));
                }
                trunc = trunc.trim();
                int equals = trunc.indexOf(61);
                String key = (String)path + trunc.substring(0, equals);
                String value = trunc.substring(equals + 1);
                if (transformer != null) {
                    String newValue = transformer.transformValue(key, value);
                    String newComment = transformer.transformValueComment(key, value, comment);
                    if (!Objects.equals(value, newValue)) {
                        line = ((String)line).replaceFirst("=(\\s*)\\Q" + value + "\\E", "=$1" + newValue);
                    }
                    if (!Objects.equals(comment, newComment)) {
                        line = (String)(((String)line).contains(";") ? ((String)line).substring(0, ((String)line).indexOf(59) + 1) : (String)line + " ;") + newComment;
                    }
                }
                int lineNumF = lineNum;
                data.compute(key, (k, l) -> {
                    if (l == null) {
                        l = new ArrayList<BlameString>();
                    }
                    l.add(new BlameString(value, fileName, lineNumF));
                    return l;
                });
            }
            if (w != null) {
                w.write((String)line);
                w.write("\r\n");
            }
            ++lineNum;
        }
    }

    private static class BlameString {
        public final String value;
        public final String file;
        public final int line;

        private BlameString(String value) {
            this(value, null, -1);
        }

        private BlameString(String value, String file, int line) {
            this.value = value;
            this.file = file;
            this.line = line;
        }

        public String blame() {
            return this.line == -1 ? "<unknown>" : "line " + this.line + " in " + this.file;
        }
    }

    public static class BadValueException
    extends QDIniException {
        public BadValueException() {
        }

        public BadValueException(String message, Throwable cause) {
            super(message, cause);
        }

        public BadValueException(String s) {
            super(s);
        }

        public BadValueException(Throwable cause) {
            super(cause);
        }
    }

    public static interface IniTransformer {
        public static IniTransformer simpleValueIniTransformer(final ValueIniTransformer transformer) {
            return new IniTransformer(){

                @Override
                public String transformLine(String path, String line) {
                    return line;
                }

                @Override
                public String transformValueComment(String key, String value, String comment) {
                    return comment;
                }

                @Override
                public String transformValue(String key, String value) {
                    return transformer.transformValue(key, value);
                }
            };
        }

        public static IniTransformer simpleLineIniTransformer(final ValueLineTransformer transformer) {
            return new IniTransformer(){

                @Override
                public String transformLine(String path, String line) {
                    return transformer.transformLine(path, line);
                }

                @Override
                public String transformValueComment(String key, String value, String comment) {
                    return comment;
                }

                @Override
                public String transformValue(String key, String value) {
                    return value;
                }
            };
        }

        default public IniTransformer andThen(IniTransformer other) {
            return new CompositeIniTransformer(this, other);
        }

        public String transformLine(String var1, String var2);

        public String transformValueComment(String var1, String var2, String var3);

        public String transformValue(String var1, String var2);
    }

    public static class SyntaxErrorException
    extends QDIniException {
        public SyntaxErrorException() {
        }

        public SyntaxErrorException(String message, Throwable cause) {
            super(message, cause);
        }

        public SyntaxErrorException(String s) {
            super(s);
        }

        public SyntaxErrorException(Throwable cause) {
            super(cause);
        }
    }

    @FunctionalInterface
    public static interface ValueLineTransformer {
        public String transformLine(String var1, String var2);
    }

    @FunctionalInterface
    public static interface ValueIniTransformer {
        public String transformValue(String var1, String var2);
    }

    public static class CompositeIniTransformer
    implements IniTransformer {
        final IniTransformer first;
        final IniTransformer second;

        CompositeIniTransformer(IniTransformer first, IniTransformer second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public String transformLine(String path, String line) {
            return this.second.transformLine(path, this.first.transformLine(path, line));
        }

        @Override
        public String transformValueComment(String key, String value, String comment) {
            return this.second.transformValueComment(key, value, this.first.transformValueComment(key, value, comment));
        }

        @Override
        public String transformValue(String key, String value) {
            return this.second.transformValue(key, this.first.transformValue(key, value));
        }
    }

    public static class QDIniException
    extends IllegalArgumentException {
        public QDIniException() {
        }

        public QDIniException(String message, Throwable cause) {
            super(message, cause);
        }

        public QDIniException(String s) {
            super(s);
        }

        public QDIniException(Throwable cause) {
            super(cause);
        }
    }
}

