/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.utils;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.utils.MapType;

public final class Slice {
    private final MapType type;
    @Nullable
    private final Integer height;
    private final ResourceKey<Level> dimension;

    private Slice(MapType type, Integer height, ResourceKey<Level> dimension) {
        this.type = type;
        this.height = height;
        this.dimension = dimension;
    }

    public static Slice of(MapType type, @Nullable Integer height, ResourceKey<Level> dimension) {
        if (height != null && height.equals(Integer.MAX_VALUE)) {
            height = null;
        }
        return new Slice(type, height, dimension);
    }

    public static Slice parse(CompoundTag t, ResourceKey<Level> dimension) {
        int anInt = t.m_128451_("type");
        if (anInt >= MapType.values().length) {
            anInt = 0;
        }
        return Slice.of(MapType.values()[anInt], t.m_128451_("height"), dimension);
    }

    public CompoundTag save() {
        CompoundTag t = new CompoundTag();
        t.m_128405_("type", this.type.ordinal());
        t.m_128405_("height", this.heightOrTop());
        return t;
    }

    public String toString() {
        return "Slice{type=" + String.valueOf((Object)this.type) + ", height=" + this.height + "}";
    }

    public int heightOrTop() {
        return this.height == null ? Integer.MAX_VALUE : this.height;
    }

    public MapType type() {
        return this.type;
    }

    @Nullable
    public Integer height() {
        return this.height;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slice slice = (Slice)o;
        return this.type == slice.type && Objects.equals(this.height, slice.height) && Objects.equals(this.dimension, slice.dimension);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.height, this.dimension});
    }

    public String getMapString(int id) {
        return this.type.makeStringKey(id);
    }

    public boolean hasMarkers() {
        return this.type.hasMarkers();
    }

    public int getDiscoveryReach() {
        return this.type.getDiscoveryReach(this.height);
    }

    public ItemStack createNewMap(int destX, int destZ, byte scale, Level level, ItemStack atlas) {
        return this.type.createNewMapItem(destX, destZ, scale, level, this.height, atlas);
    }

    public boolean isSameGroup(Slice slice) {
        return slice.dimension.equals(this.dimension) && slice.type == this.type;
    }
}

