/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.trades.trades;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class JsonTradeOffer {
    protected int maxUses;
    protected int experience;
    protected float priceMultiplier;

    @NotNull
    public abstract VillagerTrades.ItemListing deserialize(JsonObject var1);

    protected void loadDefaultStats(JsonObject jsonObject) {
        this.maxUses = JsonTradeOffer.readInt(jsonObject, "max_uses", 12);
        this.experience = JsonTradeOffer.readInt(jsonObject, "villager_experience", 1);
        this.priceMultiplier = JsonTradeOffer.readFloat(jsonObject, "price_multiplier", 0.05f);
    }

    public static int readInt(JsonObject object, String key, int defaultValue) {
        return object.has(key) ? object.get(key).getAsInt() : defaultValue;
    }

    public static float readFloat(JsonObject object, String key, float defaultValue) {
        return object.has(key) ? object.get(key).getAsFloat() : defaultValue;
    }

    public static String readString(JsonObject object, String key, String defaultValue) {
        return object.has(key) ? object.get(key).getAsString() : defaultValue;
    }

    public static ResourceLocation readIdentifier(JsonObject object, String key, String defaultValue) {
        return object.has(key) ? ResourceLocation.m_135820_((String)object.get(key).getAsString()) : new ResourceLocation(defaultValue);
    }

    public static ItemStack getItemStackFromJson(JsonObject json) {
        Optional item = BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)json.get("item").getAsString()));
        if (item.isPresent()) {
            int count = json.has("count") ? json.get("count").getAsInt() : 1;
            return new ItemStack((ItemLike)item.get(), count);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getItemStackFromJsonWithoutCount(JsonObject json) {
        Optional item = BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)json.get("item").getAsString()));
        return item.map(value -> new ItemStack((ItemLike)value, 1)).orElse(ItemStack.f_41583_);
    }
}

