/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main;

import com.dooji.underlay.main.UnderlayApi;
import com.dooji.underlay.main.UnderlayManager;
import com.dooji.underlay.main.network.UnderlayNetworking;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="underlay")
public class Underlay {
    public static final String MOD_ID = "underlay";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"underlay");
    private static final TagKey<Block> OVERLAY_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.m_214293_((String)"underlay", (String)"overlay"));
    public static final TagKey<Block> EXCLUDE_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.m_214293_((String)"underlay", (String)"exclude"));

    public Underlay() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(UnderlayNetworking::init);
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        for (ServerLevel world : event.getServer().m_129785_()) {
            LOGGER.info("Loading overlays for world: " + world.m_46472_().m_135782_());
            UnderlayManager.loadOverlays((Level)world);
            Underlay.reloadDatapackBlocks(world);
        }
    }

    private static void reloadDatapackBlocks(ServerLevel world) {
        UnderlayApi.CUSTOM_BLOCKS_DP.clear();
        Registry blocks = world.m_9598_().m_175515_(Registries.f_256747_);
        blocks.m_203431_(OVERLAY_TAG).ifPresent(tag -> tag.forEach(entry -> {
            Block block = (Block)entry.m_203334_();
            if (!blocks.m_203561_(EXCLUDE_TAG).m_203333_(entry)) {
                UnderlayApi.registerDatapackOverlayBlock(block);
            }
        }));
    }
}

