/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.client;

import com.dooji.underlay.client.UnderlayManagerClient;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;

public class UnderlayRenderer {
    private static final Map<BlockPos, BlockState> RENDER_CACHE = new ConcurrentHashMap<BlockPos, BlockState>();
    private static long lastFullRefreshTime = 0L;
    private static final long FULL_REFRESH_INTERVAL = 500L;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(UnderlayRenderer::onRenderLevel);
    }

    public static void registerOverlay(BlockPos pos, BlockState state) {
        RENDER_CACHE.put(pos.m_7949_(), state);
    }

    public static void unregisterOverlay(BlockPos pos) {
        RENDER_CACHE.remove(pos);
    }

    public static void clearAllOverlays() {
        RENDER_CACHE.clear();
    }

    public static void forceRefresh() {
        lastFullRefreshTime = System.currentTimeMillis();
        UnderlayRenderer.clearAllOverlays();
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null && client.f_91074_ != null) {
            BlockPos playerPos = client.f_91074_.m_20183_();
            int radius = 64;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -16; y <= 16; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = playerPos.m_7918_(x, y, z);
                        if (!UnderlayManagerClient.hasOverlay(pos)) continue;
                        UnderlayRenderer.registerOverlay(pos, UnderlayManagerClient.getOverlay(pos));
                    }
                }
            }
        }
    }

    private static void checkForFullRefresh() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastFullRefreshTime > 500L) {
            UnderlayRenderer.forceRefresh();
        }
    }

    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderer = client.m_91289_();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cameraPos = client.f_91063_.m_109153_().m_90583_();
        if (bufferSource == null || client.f_91073_ == null || client.f_91074_ == null) {
            return;
        }
        UnderlayRenderer.checkForFullRefresh();
        poseStack.m_85836_();
        for (Map.Entry<BlockPos, BlockState> entry : RENDER_CACHE.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            int chunks = (Integer)client.f_91066_.m_231984_().m_231551_();
            int blocks = chunks * 16;
            double maxDistSq = (double)blocks * (double)blocks;
            double distanceSq = pos.m_123331_((Vec3i)client.f_91074_.m_20183_());
            if (distanceSq > maxDistSq) continue;
            if (!UnderlayManagerClient.hasOverlay(pos)) {
                RENDER_CACHE.remove(pos);
                continue;
            }
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_() - cameraPos.f_82479_, (double)pos.m_123342_() - cameraPos.f_82480_, (double)pos.m_123343_() - cameraPos.f_82481_);
            int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)client.f_91073_, (BlockPos)pos);
            int packedOverlay = OverlayTexture.f_118083_;
            blockRenderer.renderSingleBlock(state, poseStack, (MultiBufferSource)bufferSource, packedLight, packedOverlay, ModelData.EMPTY, RenderType.m_110457_());
            poseStack.m_85849_();
        }
        bufferSource.m_109912_(RenderType.m_110457_());
        poseStack.m_85849_();
    }
}

