/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.client;

import com.dooji.underlay.client.UnderlayManagerClient;
import com.dooji.underlay.client.UnderlayRaycast;
import com.dooji.underlay.client.UnderlayRenderer;
import com.dooji.underlay.main.network.UnderlayNetworking;
import com.dooji.underlay.main.network.payloads.AddOverlayPayload;
import com.dooji.underlay.main.network.payloads.RemoveOverlayPayload;
import com.dooji.underlay.main.network.payloads.SyncOverlaysPayload;
import com.dooji.underlay.mixin.MultiPlayerGameModeAccessor;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="underlay", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class UnderlayClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(UnderlayClient::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(UnderlayClient::onLevelUnload);
        MinecraftForge.EVENT_BUS.addListener(UnderlayClient::onClientDisconnect);
        event.enqueueWork(() -> {});
        UnderlayRenderer.init();
    }

    private static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        UnderlayRenderer.clearAllOverlays();
        UnderlayManagerClient.removeAll();
    }

    public static void handleSyncPacket(SyncOverlaysPayload payload) {
        Minecraft client = Minecraft.m_91087_();
        Map<BlockPos, BlockState> map = payload.tags().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> NbtUtils.m_247651_((HolderGetter)client.f_91073_.m_246945_(Registries.f_256747_), (CompoundTag)((CompoundTag)e.getValue()))));
        UnderlayManagerClient.sync(map);
        UnderlayRenderer.clearAllOverlays();
        UnderlayManagerClient.getAll().forEach(UnderlayRenderer::registerOverlay);
    }

    public static void handleAddPacket(AddOverlayPayload payload) {
        BlockPos pos = payload.pos();
        Minecraft client = Minecraft.m_91087_();
        BlockState state = NbtUtils.m_247651_((HolderGetter)client.f_91073_.m_246945_(Registries.f_256747_), (CompoundTag)payload.stateTag());
        UnderlayManagerClient.syncAdd(pos, state);
        UnderlayRenderer.registerOverlay(pos, state);
        client.f_91073_.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), state.m_60827_().m_56777_(), SoundSource.BLOCKS, state.m_60827_().m_56773_(), state.m_60827_().m_56774_(), false);
    }

    public static void handleRemovePacket(RemoveOverlayPayload payload) {
        BlockPos pos = payload.pos();
        Minecraft client = Minecraft.m_91087_();
        BlockState state = UnderlayManagerClient.getOverlay(pos);
        UnderlayRenderer.unregisterOverlay(pos);
        UnderlayManagerClient.syncRemove(pos);
        if (state != null) {
            assert (client.f_91073_ != null);
            client.f_91073_.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), state.m_60827_().m_56775_(), SoundSource.BLOCKS, state.m_60827_().m_56773_(), state.m_60827_().m_56774_(), false);
        }
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft client = Minecraft.m_91087_();
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (client.f_91074_ == null || client.f_91073_ == null || client.f_91080_ != null) {
            return;
        }
        UnderlayClient.handleContinuousBreaking(client);
    }

    private static void handleContinuousBreaking(Minecraft client) {
        if (client.f_91066_.f_92096_.m_90857_()) {
            BlockPos hit = UnderlayClient.findOverlayUnderCrosshair(client);
            MultiPlayerGameModeAccessor playerInteraction = (MultiPlayerGameModeAccessor)client.f_91072_;
            if (hit != null && playerInteraction != null && playerInteraction.getBlockBreakingCooldown() == 0) {
                UnderlayClient.breakOverlay(client, hit);
            }
        }
    }

    public static void breakOverlay(Minecraft client, BlockPos pos) {
        MultiPlayerGameModeAccessor interactionManager = (MultiPlayerGameModeAccessor)client.f_91072_;
        UnderlayNetworking.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new RemoveOverlayPayload(pos));
        interactionManager.setBlockBreakingCooldown(5);
    }

    private static void onLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            UnderlayRenderer.clearAllOverlays();
            UnderlayManagerClient.removeAll();
        }
    }

    public static BlockPos findOverlayUnderCrosshair(Minecraft client) {
        BlockHitResult hit = UnderlayRaycast.trace((Entity)client.f_91074_, client.f_91072_.m_105286_(), client.m_91296_());
        return hit == null ? null : hit.m_82425_();
    }
}

