/*
 * Decompiled with CFR 0.152.
 */
package toni.foolproof.foundation;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FoolproofPersistentData {
    public static final File FILE = new File("foolproof.json");
    public static Date timeStarted = new Date();
    public static final Codec<FoolproofPersistentData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("playtime").forGetter(data -> data.playtime), (App)Codec.STRING.listOf().optionalFieldOf("seenWarnings", new ArrayList()).forGetter(data -> data.seenWarnings.stream().toList())).apply((Applicative)instance, FoolproofPersistentData::new));
    public int playtime;
    public Set<String> seenWarnings;

    public FoolproofPersistentData(Integer playtime, List<String> seenTips) {
        this.playtime = playtime;
        this.seenWarnings = new HashSet<String>(seenTips);
    }

    public void save() {
        long millis = new Date().getTime() - timeStarted.getTime();
        this.playtime += (int)(millis / 1000L);
        timeStarted = new Date();
        try (FileWriter writer = new FileWriter(FILE);){
            JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow(false, error -> {
                throw new RuntimeException("Failed to encode Foolproof PersistentData: " + error);
            });
            writer.write(jsonElement.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save Foolproof PersistentData! ", e);
        }
    }

    public static FoolproofPersistentData load() {
        FoolproofPersistentData foolproofPersistentData;
        if (!FILE.exists()) {
            return new FoolproofPersistentData(0, new ArrayList<String>());
        }
        FileReader reader = new FileReader(FILE);
        try {
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            foolproofPersistentData = (FoolproofPersistentData)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, error -> {
                throw new RuntimeException("Failed to decode Foolproof PersistentData: " + error);
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load Foolproof PersistentData! ", e);
            }
        }
        reader.close();
        return foolproofPersistentData;
    }
}

