/*
 * Decompiled with CFR 0.152.
 */
package toni.foolproof;

import java.lang.reflect.Field;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.slf4j.Log4jLogger;
import toni.foolproof.ClientEvents;
import toni.foolproof.features.VoidGraveReminder;
import toni.foolproof.foundation.FoolproofPersistentData;
import toni.foolproof.foundation.config.AllConfigs;

@Mod(value="foolproof")
public class Foolproof {
    public static final String MODNAME = "Foolproof";
    public static final String ID = "foolproof";
    public static final Logger LOGGER = LogManager.getLogger((String)"Foolproof");
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final AtomicLong serverStartTime = new AtomicLong(0L);
    public static FoolproofPersistentData DATA;

    public Foolproof() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        AllConfigs.register((type, spec) -> ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec));
    }

    public static boolean hasSeenWarning(String warning) {
        return Foolproof.DATA.seenWarnings.contains(warning);
    }

    public void onInitialize() {
        VoidGraveReminder.init();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> DATA.save());
        try {
            Field log4jField = Log4jLogger.class.getDeclaredField("logger");
            log4jField.setAccessible(true);
            org.apache.logging.log4j.core.Logger log4jLogger = (org.apache.logging.log4j.core.Logger)log4jField.get(MinecraftServer.f_129750_);
            log4jLogger.addFilter((Filter)new AbstractFilter(){

                public Filter.Result filter(LogEvent event) {
                    String msg = event.getMessage().getFormattedMessage();
                    if (msg != null && msg.contains("Can't keep up!")) {
                        long elapsed = System.currentTimeMillis() - serverStartTime.get();
                        if (serverStartTime.get() == 0L || elapsed < 120000L) {
                            return Filter.Result.DENY;
                        }
                    }
                    return Filter.Result.NEUTRAL;
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("Could not install log filter:");
            LOGGER.warn(e.getMessage());
        }
    }

    public void onInitializeClient() {
        DATA = FoolproofPersistentData.load();
        ClientEvents.init();
    }

    private void onServerStarted(MinecraftServer server) {
        serverStartTime.set(System.currentTimeMillis());
        scheduler.schedule(() -> System.out.println("[SERVER] The server is fully started and ready to join!"), 5L, TimeUnit.SECONDS);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.onInitialize();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }
}

