/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;

public class EnchantmentHelper {
    public static ItemStack getRandomEnchantedBook(int levels, boolean allowMultiple, boolean allowCurses, boolean allowTreasure, RandomSource random, FeatureFlagSet featureFlags) {
        return EnchantmentHelper.enchantItem(new ItemStack((ItemLike)Items.f_42517_), levels, allowMultiple, allowCurses, allowTreasure, random, featureFlags);
    }

    public static ItemStack enchantItem(ItemStack stack, int levels, boolean allowMultiple, boolean allowCurses, boolean allowTreasure, RandomSource random, FeatureFlagSet featureFlags) {
        List enchantments;
        int enchantmentValue = stack.getEnchantmentValue();
        if (enchantmentValue <= 0) {
            return stack;
        }
        levels += 1 + random.m_188503_(enchantmentValue / 4 + 1) + random.m_188503_(enchantmentValue / 4 + 1);
        float multiplier = (random.m_188501_() + random.m_188501_() - 1.0f) * 0.15f + 1.0f;
        levels = Math.max(1, Math.round((float)levels * multiplier));
        ArrayList<EnchantmentInstance> options = new ArrayList<EnchantmentInstance>();
        boolean isBook = stack.m_150930_(Items.f_42517_);
        block0: for (Object enchantment : BuiltInRegistries.f_256876_) {
            if (!enchantment.m_6592_() || !allowCurses && enchantment.m_6589_() || !allowTreasure && enchantment.m_6591_() || (!isBook || !enchantment.isAllowedOnBooks()) && !enchantment.canApplyAtEnchantingTable(stack)) continue;
            for (int level = enchantment.m_6586_(); level >= enchantment.m_44702_(); --level) {
                if (levels < enchantment.m_6183_(level) || levels > enchantment.m_6175_(level)) continue;
                options.add(new EnchantmentInstance((Enchantment)enchantment, level));
                continue block0;
            }
        }
        if (options.isEmpty()) {
            return stack;
        }
        if (allowMultiple) {
            enchantments = new ArrayList();
            WeightedRandom.m_216822_((RandomSource)random, options).ifPresent(enchantments::add);
            while (random.m_188503_(50) <= levels) {
                if (!enchantments.isEmpty()) {
                    net.minecraft.world.item.enchantment.EnchantmentHelper.m_44862_(options, (EnchantmentInstance)((EnchantmentInstance)Util.m_137509_(enchantments)));
                }
                if (!options.isEmpty()) {
                    WeightedRandom.m_216822_((RandomSource)random, options).ifPresent(enchantments::add);
                    levels /= 2;
                    continue;
                }
                break;
            }
        } else {
            enchantments = WeightedRandom.m_216822_((RandomSource)random, options).map(List::of).orElseGet(List::of);
        }
        if (enchantments.isEmpty()) {
            return stack;
        }
        if (stack.m_150930_(Items.f_42517_)) {
            stack = new ItemStack((ItemLike)Items.f_42690_);
        }
        if (allowMultiple) {
            for (EnchantmentInstance enchantment : enchantments) {
                stack.m_41663_(enchantment.f_44947_, enchantment.f_44948_);
            }
        } else {
            Object enchantment;
            enchantment = (EnchantmentInstance)enchantments.get(0);
            stack.m_41663_(((EnchantmentInstance)enchantment).f_44947_, ((EnchantmentInstance)enchantment).f_44948_);
        }
        return stack;
    }
}

