/*
 * Decompiled with CFR 0.152.
 */
package com.iwaliner.item_split_bug_fix;

import com.iwaliner.item_split_bug_fix.ConfigItemSplitBugFix;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="item_split_bug_fix")
public class ModCoreItemSplitBugFix {
    public static final String MODID = "item_split_bug_fix";
    private static List<Pattern> blacklistPattern = new ArrayList<Pattern>();
    private static Set<Item> blacklistCache = new HashSet<Item>();
    private static Set<Item> checkedItemsCache = new HashSet<Item>();

    public ModCoreItemSplitBugFix() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigItemSplitBugFix.CONFIG_SPEC, "ItemSplitBugFix.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static boolean isItemOnBlacklist(ItemStack stack) {
        if (stack == null || stack.m_41619_() || blacklistPattern.isEmpty()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (blacklistCache.contains(item)) {
            return true;
        }
        if (checkedItemsCache.contains(item)) {
            return false;
        }
        ResourceLocation RLItemId = ForgeRegistries.ITEMS.getKey((Object)item);
        if (RLItemId == null) {
            return true;
        }
        String id = RLItemId.toString();
        ModCoreItemSplitBugFix.prepareBlacklist();
        for (Pattern p : blacklistPattern) {
            if (!p.matcher(id).matches()) continue;
            blacklistCache.add(item);
            return true;
        }
        checkedItemsCache.add(item);
        return false;
    }

    public static boolean isSplitItemStack(ItemStack stack) {
        ModCoreItemSplitBugFix.prepareBlacklist();
        if (ModCoreItemSplitBugFix.isItemOnBlacklist(stack)) {
            return false;
        }
        return stack.m_41783_() != null && stack.m_41783_().m_128456_();
    }

    public static void prepareBlacklist() {
        if (!blacklistPattern.isEmpty()) {
            return;
        }
        List list = (List)ConfigItemSplitBugFix.BLACKLIST_ITEMS.get();
        if (list != null) {
            for (String s : list) {
                String regex = s.replace("*", ".*");
                blacklistPattern.add(Pattern.compile(regex));
            }
            blacklistCache.clear();
            checkedItemsCache.clear();
        }
    }

    public static void fixBug(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        if (ModCoreItemSplitBugFix.isItemOnBlacklist(stack)) {
            return;
        }
        if (ModCoreItemSplitBugFix.isSplitItemStack(stack)) {
            stack.m_41751_(null);
        }
    }
}

