/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityAbsBeam;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityMagicEffects;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityCrimsonRay
extends EntityAbsBeam {
    private static final EntityDataAccessor<Integer> DATA_ATTACK_HEIGHT = SynchedEntityData.m_135353_(EntityCrimsonRay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityCrimsonRay(EntityType<? extends EntityCrimsonRay> type, Level level) {
        super(type, level, 1);
    }

    public EntityCrimsonRay(Level world, LivingEntity caster, Vec3 pos, int duration, int attackHeight) {
        this((EntityType<? extends EntityCrimsonRay>)((EntityType)EntityInit.CRIMSON_RAY.get()), world);
        this.caster = caster;
        this.setPitch(1.5707964f);
        this.setYaw((float)((double)(this.m_146908_() - 90.0f) * Math.PI / 180.0));
        this.setDuration(duration);
        this.m_146884_(pos);
        this.setAttackHeight(attackHeight);
        this.calculateEndPos(16.0);
        if (!this.m_9236_().f_46443_) {
            this.setCasterId(caster.m_19879_());
        }
    }

    @Override
    public void beamTick() {
        if (this.f_19797_ >= this.getCountDown()) {
            if (this.f_19797_ == this.getCountDown()) {
                this.m_5496_((SoundEvent)SoundInit.CRIMSON_RAY.get(), 0.25f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * -0.2f + 1.0f);
            }
            this.calculateEndPos(this.getAttackHeight());
            List<LivingEntity> hit = this.raytraceEntities(this.m_9236_(), new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ)).getEntities();
            if (this.blockSide != null) {
                if (!this.m_9236_().f_46443_) {
                    BlockPos minPos = new BlockPos(Mth.m_14107_((double)(this.collidePosX - 0.5)), Mth.m_14107_((double)(this.collidePosY - 0.5)), Mth.m_14107_((double)(this.collidePosZ - 0.5)));
                    BlockPos maxPos = new BlockPos(Mth.m_14107_((double)(this.collidePosX + 0.5)), Mth.m_14107_((double)(this.collidePosY + 0.5)), Mth.m_14107_((double)(this.collidePosZ + 0.5)));
                    BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> {
                        if (ModEntityUtils.canDestroyBlock(this.m_9236_(), pos, this, 50.0f) && ModEntityUtils.canMobDestroy(this)) {
                            this.m_9236_().m_46961_(pos, false);
                        }
                    });
                } else {
                    this.spawnExplosionParticles();
                }
            }
            if (!this.m_9236_().f_46443_) {
                for (LivingEntity target : hit) {
                    if (target == this.caster) continue;
                    target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.caster), 5.0f + target.m_21233_() * 0.01f);
                }
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ATTACK_HEIGHT, (Object)16);
    }

    public int getAttackHeight() {
        return (Integer)this.m_20088_().m_135370_(DATA_ATTACK_HEIGHT);
    }

    public void setAttackHeight(int attackHeight) {
        this.m_20088_().m_135381_(DATA_ATTACK_HEIGHT, (Object)attackHeight);
    }

    @Override
    protected void spawnExplosionParticles() {
        for (int i = 0; i < 2; ++i) {
            float velocity = 0.12f;
            float yaw = (float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI);
            float motionY = this.f_19796_.m_188501_() * -0.12f;
            float motionX = 0.12f * Mth.m_14089_((float)yaw);
            float motionZ = 0.12f * Mth.m_14031_((float)yaw);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public static class PreAttack
    extends EntityMagicEffects {
        private final ControlledAnimation phaseController = new ControlledAnimation(2);
        private static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.m_135353_(PreAttack.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        public int attackHeight = 16;
        private Vec3 pos;

        public PreAttack(EntityType<?> type, Level level) {
            super(type, level);
        }

        public PreAttack(Level level, Vec3 pos, LivingEntity caster, int attackHeight) {
            this((EntityType)EntityInit.CRIMSON_RAY_PRE.get(), level);
            this.pos = pos;
            this.caster = caster;
            this.attackHeight = attackHeight;
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(DATA_PHASE, (Object)0);
        }

        @Override
        public void m_8119_() {
            super.m_8119_();
            if (!this.m_9236_().f_46443_) {
                if (this.pos == null || this.caster == null) {
                    this.m_146870_();
                    return;
                }
                switch (this.getPhase()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (!this.phaseController.increaseTimerChain().isEnd()) break;
                        this.setPhase(this.getPhase() + 1);
                        this.phaseController.resetTimer();
                        break;
                    }
                    case 5: {
                        if (!this.phaseController.increaseTimerChain().isEnd()) break;
                        this.m_9236_().m_7967_((Entity)new EntityCrimsonRay(this.m_9236_(), this.caster, this.pos, 10, this.attackHeight));
                        this.m_146870_();
                    }
                }
            }
        }

        public boolean m_6783_(double distance) {
            return distance < 4096.0;
        }

        public int getPhase() {
            return (Integer)this.f_19804_.m_135370_(DATA_PHASE);
        }

        public void setPhase(int phase) {
            this.f_19804_.m_135381_(DATA_PHASE, (Object)phase);
        }
    }
}

