/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.config;

import com.eeeab.eeeabsmobs.sever.util.EMTUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="eeeabsmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class EMConfigHandler {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final Common COMMON;

    private EMConfigHandler() {
    }

    private static String getTranslationKey(String key) {
        return EMTUtils.simpleConfigText(key, null, new Object[0]).getString();
    }

    static {
        COMMON = new Common(BUILDER);
        SPEC = BUILDER.build();
    }

    public static class Common {
        public final Mob MOB;
        public final Entity ENTITY;
        public final Item ITEM;
        public final Other OTHER;

        public Common(ForgeConfigSpec.Builder builder) {
            this.ITEM = new Item(builder);
            this.ENTITY = new Entity(builder);
            this.MOB = new Mob(builder);
            this.OTHER = new Other(builder);
        }
    }

    public static class ToolConfig {
        public final ForgeConfigSpec.DoubleValue attackDamage;
        public final ForgeConfigSpec.DoubleValue attackSpeed;
        public double attackDamageValue;
        public double attackSpeedValue;

        ToolConfig(double attackDamage, double attackSpeed) {
            this.attackSpeedValue = attackSpeed;
            this.attackDamageValue = attackDamage;
            this.attackDamage = BUILDER.comment("Set tool attack damage").translation(EMConfigHandler.getTranslationKey("tool_damage")).defineInRange("Attack damage", attackDamage, 0.0, 3.4028234663852886E38);
            this.attackSpeed = BUILDER.comment("Set tool attack speed").translation(EMConfigHandler.getTranslationKey("tool_speed")).defineInRange("Attack speed", attackSpeed, 0.0, 3.4028234663852886E38);
        }
    }

    public static class DamageSourceAdaptConfig {
        public final ForgeConfigSpec.IntValue maxDamageSourceAdaptCount;
        public final ForgeConfigSpec.IntValue resetCountdown;
        public final ForgeConfigSpec.DoubleValue singleAdaptFactor;
        public final ForgeConfigSpec.DoubleValue maxAdaptFactor;
        public final ForgeConfigSpec.BooleanValue adaptBypassesDamage;
        public final boolean adaptsSameTypeMobs;

        public DamageSourceAdaptConfig(ForgeConfigSpec.Builder builder, int maxDamageSourceAdaptCount, int resetCountdown, double singleAdaptFactor, double maxAdaptFactor, boolean adaptsSameTypeMobs, boolean adaptBypassesDamage) {
            builder.push("Damage Adapt");
            this.maxDamageSourceAdaptCount = BUILDER.comment("Set max adaptable damage sources for this mob").translation(EMConfigHandler.getTranslationKey("damage_adapt_1")).defineInRange("Max supported damage types amount", maxDamageSourceAdaptCount, 10, 1024);
            this.resetCountdown = BUILDER.comment("Set the effective duration for a single adaptation damage source (in seconds)").translation(EMConfigHandler.getTranslationKey("damage_adapt_2")).defineInRange("Adaptation duration", resetCountdown, 10, 1024);
            this.singleAdaptFactor = BUILDER.comment("Set the reduction factor for each instance of the same damage source").translation(EMConfigHandler.getTranslationKey("damage_adapt_3")).defineInRange("Single hurt post adaptation value", singleAdaptFactor, 0.0, 1.0);
            this.maxAdaptFactor = BUILDER.comment("Set the maximum damage reduction factor").translation(EMConfigHandler.getTranslationKey("damage_adapt_4")).defineInRange("Same damage max adaptation factor", maxAdaptFactor, 0.0, 1.0);
            this.adaptsSameTypeMobs = adaptsSameTypeMobs;
            this.adaptBypassesDamage = BUILDER.comment("If set to 'False' disable adaptation to out of world and generic kill damage source").translation(EMConfigHandler.getTranslationKey("damage_adapt_5")).define("Adaptation bypasses damage source", adaptBypassesDamage);
            builder.pop();
        }
    }

    public static class DamageCapConfig {
        public final ForgeConfigSpec.DoubleValue damageCap;

        public DamageCapConfig(double damageCapPercentage) {
            this.damageCap = BUILDER.comment("Set this mob damageCap").translation(EMConfigHandler.getTranslationKey("damage_cap")).defineInRange("DamageCap", damageCapPercentage, 0.0, 1024.0);
        }
    }

    public static class AttributeConfig {
        public final ForgeConfigSpec.DoubleValue healthMultiplier;
        public final ForgeConfigSpec.DoubleValue attackMultiplier;

        public AttributeConfig() {
            this(1.0f, 1.0f);
        }

        public AttributeConfig(float healthMultiplier, float attackMultiplier) {
            this.healthMultiplier = BUILDER.comment("Set this mob health multiplier").translation(EMConfigHandler.getTranslationKey("mob_health")).defineInRange("Health multiplier", (double)healthMultiplier, 0.0, Double.MAX_VALUE);
            this.attackMultiplier = BUILDER.comment("Set this mob attack multiplier").translation(EMConfigHandler.getTranslationKey("mob_attack")).defineInRange("Attack multiplier", (double)attackMultiplier, 0.0, Double.MAX_VALUE);
        }
    }

    public static class Other {
        public final ForgeConfigSpec.BooleanValue enableCameraShake;
        public final ForgeConfigSpec.BooleanValue enableShowBloodBars;
        public final ForgeConfigSpec.BooleanValue enablePlayBossMusic;
        public final ForgeConfigSpec.BooleanValue enableBossCanBreakingBlockDropItem;
        public final ForgeConfigSpec.BooleanValue enableSameMobsTypeInjury;
        public final ForgeConfigSpec.BooleanValue enableFrenzyDestroyBlock;
        public final ForgeConfigSpec.BooleanValue enableShowItemCD;

        public Other(ForgeConfigSpec.Builder builder) {
            builder.push("Others");
            builder.push("Camera");
            this.enableCameraShake = BUILDER.comment("If set to 'False' disable camera shake").translation(EMConfigHandler.getTranslationKey("camera_1")).define("Enable camera shake", true);
            builder.pop();
            builder.push("Bosses");
            this.enableShowBloodBars = BUILDER.comment("If set to 'False' disable bosses blood bars").translation(EMConfigHandler.getTranslationKey("bosses_1")).define("Enable bosses blood bars", true);
            this.enablePlayBossMusic = BUILDER.comment("If set to 'False' disable play boss music").translation(EMConfigHandler.getTranslationKey("bosses_2")).define("Enable play bosses musics", true);
            this.enableBossCanBreakingBlockDropItem = BUILDER.comment("If set to 'False' disable bosses breaking blocks drop items").translation(EMConfigHandler.getTranslationKey("bosses_3")).define("Enable bosses breaking blocks drop items", false);
            builder.pop();
            builder.push("Misc");
            this.enableSameMobsTypeInjury = BUILDER.comment("If set to 'False' able inflict damage between mobs of the same team").translation(EMConfigHandler.getTranslationKey("misc_1")).define("Enable allied damage protection", true);
            this.enableFrenzyDestroyBlock = BUILDER.comment("If set to 'False' disable frenzy potion destroy block").translation(EMConfigHandler.getTranslationKey("misc_2")).define("Enable frenzy potion destroy block", false);
            this.enableShowItemCD = BUILDER.comment("If set to 'False' disable showing cooldown time in tooltip").translation(EMConfigHandler.getTranslationKey("misc_3")).define("Enable show item cd", false);
            builder.pop();
            builder.pop();
        }
    }

    public static class CorpseToPlayer {
        public final AttributeConfig combatConfig;
        public final ForgeConfigSpec.DoubleValue minionDeathHealAmount;

        public CorpseToPlayer(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse Minion");
            this.combatConfig = new AttributeConfig();
            this.minionDeathHealAmount = BUILDER.comment("Set corpse minion to restore its owner's health").translation(EMConfigHandler.getTranslationKey("corpse_to_player")).defineInRange("Death Heal Amount", 5.0, 0.0, 1024.0);
            builder.pop();
        }
    }

    public static class MinionMobs {
        public final CorpseToPlayer CORPSE_MINION;

        public MinionMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Minion Mobs");
            this.CORPSE_MINION = new CorpseToPlayer(builder);
            builder.pop();
        }
    }

    public static class NamelessGuardian {
        public final ForgeConfigSpec.BooleanValue enableNonCombatHeal;
        public final ForgeConfigSpec.DoubleValue suckBloodMultiplier;
        public final ForgeConfigSpec.BooleanValue enableForcedSuckBlood;
        public final ForgeConfigSpec.BooleanValue challengeMode;
        public final ForgeConfigSpec.IntValue extraInvulnerableTick;
        public final ForgeConfigSpec.BooleanValue intervalProtect;
        public final AttributeConfig combatConfig;
        public final DamageCapConfig maximumDamageCap;

        public NamelessGuardian(ForgeConfigSpec.Builder builder) {
            builder.push("Nameless Guardian");
            this.suckBloodMultiplier = BUILDER.comment("Set suck blood multiplier").translation(EMConfigHandler.getTranslationKey("suck_blood")).defineInRange("Suck blood multiplier", 1.0, 0.0, 1024.0);
            this.extraInvulnerableTick = BUILDER.comment("Set extra invulnerable tick(This setting does not take effect in Challenge Mode)").translation(EMConfigHandler.getTranslationKey("invulnerable_tick")).defineInRange("Extra invulnerable tick", 20, 0, 1200);
            this.enableNonCombatHeal = BUILDER.comment("If set to 'False' disable out-of-combat heal").translation(EMConfigHandler.getTranslationKey("out_of_combat")).define("Enable out-of-combat healing", true);
            this.enableForcedSuckBlood = BUILDER.comment("If set to 'False' disable forced suck blood on power status(This setting does not take effect in Challenge Mode)").translation(EMConfigHandler.getTranslationKey("forced_suck_blood")).define("Enable forced suck blood", true);
            this.challengeMode = BUILDER.comment("Be careful! It's going to get tricky!").translation(EMConfigHandler.getTranslationKey("challenge_mode")).define("Challenge Mode", false);
            this.intervalProtect = BUILDER.comment("This setting does not take effect in Challenge Mode").translation(EMConfigHandler.getTranslationKey("interval_protect")).define("Frame Damage Protection", true);
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new DamageCapConfig(20.0);
            builder.pop();
        }
    }

    public static class GulingSentinelHeavy {
        public final ForgeConfigSpec.BooleanValue enableNonCombatHeal;
        public final AttributeConfig combatConfig;

        public GulingSentinelHeavy(ForgeConfigSpec.Builder builder) {
            builder.push("Guling Sentinel-Heavy");
            this.enableNonCombatHeal = BUILDER.comment("If set to 'False' disable out-of-combat heal").translation(EMConfigHandler.getTranslationKey("out_of_combat")).define("Enable out-of-combat healing", true);
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class GulingSentinel {
        public final ForgeConfigSpec.BooleanValue enableNonCombatHeal;
        public final AttributeConfig combatConfig;

        public GulingSentinel(ForgeConfigSpec.Builder builder) {
            builder.push("Guling Sentinel");
            this.enableNonCombatHeal = BUILDER.comment("If set to 'False' disable out-of-combat heal").translation(EMConfigHandler.getTranslationKey("out_of_combat")).define("Enable out-of-combat healing", true);
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class GulingMobs {
        public final NamelessGuardian NAMELESS_GUARDIAN;
        public final GulingSentinel GULING_SENTINEL;
        public final GulingSentinelHeavy GULING_SENTINEL_HEAVY;

        public GulingMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Guling Mobs");
            this.GULING_SENTINEL = new GulingSentinel(builder);
            this.GULING_SENTINEL_HEAVY = new GulingSentinelHeavy(builder);
            this.NAMELESS_GUARDIAN = new NamelessGuardian(builder);
            builder.pop();
        }
    }

    public static class CorpseWarlock {
        public final ForgeConfigSpec.DoubleValue maxDistanceTakeDamage;
        public final AttributeConfig combatConfig;
        public final DamageCapConfig maximumDamageCap;

        public CorpseWarlock(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse Warlock");
            this.maxDistanceTakeDamage = BUILDER.comment("Set the effective distance at which projectiles can deal damage").translation(EMConfigHandler.getTranslationKey("effective_range")).defineInRange("Set projectile damage range", 12.0, 1.0, 32.0);
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new DamageCapConfig(22.0);
            builder.pop();
        }
    }

    public static class Corpse {
        public final AttributeConfig combatConfig;
        public final ForgeConfigSpec.BooleanValue enableConvertToCorpse;

        public Corpse(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse & Corpse Villager");
            this.combatConfig = new AttributeConfig();
            this.enableConvertToCorpse = BUILDER.comment("If set to 'False', When zombies or villagers are killed by corpses, they will not converted into corpses themselves").translation(EMConfigHandler.getTranslationKey("corpse")).define("Converted to corpse", true);
            builder.pop();
        }
    }

    public static class CorpseMobs {
        public final Corpse CORPSE;
        public final CorpseWarlock CORPSE_WARLOCK;

        public CorpseMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse Mobs");
            this.CORPSE = new Corpse(builder);
            this.CORPSE_WARLOCK = new CorpseWarlock(builder);
            builder.pop();
        }
    }

    public static class Immortal {
        public final ForgeConfigSpec.BooleanValue intervalProtect;
        public final ForgeConfigSpec.DoubleValue maxDistanceTakeDamage;
        public final AttributeConfig combatConfig;
        public final DamageCapConfig maximumDamageCap;
        public final DamageSourceAdaptConfig adaptConfig;

        public Immortal(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal");
            this.intervalProtect = BUILDER.translation(EMConfigHandler.getTranslationKey("interval_protect")).define("Frame Damage Protection", true);
            this.maxDistanceTakeDamage = BUILDER.comment("Set the effective distance at which projectiles can deal damage").translation(EMConfigHandler.getTranslationKey("effective_range")).defineInRange("Set projectile damage range", 15.0, 1.0, 32.0);
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new DamageCapConfig(25.0);
            this.adaptConfig = new DamageSourceAdaptConfig(builder, 100, 30, 0.1, 0.7, true, true);
            builder.pop();
        }
    }

    public static class ImmortalExecutioner {
        public final AttributeConfig combatConfig;
        public final ForgeConfigSpec.IntValue maximumDetonationCount;

        public ImmortalExecutioner(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Executioner");
            this.combatConfig = new AttributeConfig();
            this.maximumDetonationCount = BUILDER.comment("Set the number of times to strengthen this mob").translation(EMConfigHandler.getTranslationKey("immortal_executioner")).defineInRange("Ignite Count", 3, 0, 1024);
            builder.pop();
        }
    }

    public static class ImmortalGolem {
        public final AttributeConfig combatConfig;

        public ImmortalGolem(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Golem");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalShaman {
        public final AttributeConfig combatConfig;
        public final ForgeConfigSpec.DoubleValue healPercentage;

        public ImmortalShaman(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Shaman");
            this.healPercentage = BUILDER.comment("Immortal Shaman heal values (based on max health percentage)").translation(EMConfigHandler.getTranslationKey("heal_percentage")).defineInRange("Heal percentage", 0.5, 0.0, 1.0);
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalKnight {
        public final AttributeConfig combatConfig;

        public ImmortalKnight(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Knight");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalSkeleton {
        public final AttributeConfig combatConfig;

        public ImmortalSkeleton(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Skeleton");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalMobs {
        public final ImmortalSkeleton IMMORTAL_SKELETON;
        public final ImmortalKnight IMMORTAL_KNIGHT;
        public final ImmortalShaman IMMORTAL_SHAMAN;
        public final ImmortalGolem IMMORTAL_GOLEM;
        public final ImmortalExecutioner IMMORTAL_EXECUTIONER;
        public final Immortal THE_IMMORTAL;

        public ImmortalMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Mobs");
            this.IMMORTAL_SKELETON = new ImmortalSkeleton(builder);
            this.IMMORTAL_KNIGHT = new ImmortalKnight(builder);
            this.IMMORTAL_SHAMAN = new ImmortalShaman(builder);
            this.IMMORTAL_GOLEM = new ImmortalGolem(builder);
            this.IMMORTAL_EXECUTIONER = new ImmortalExecutioner(builder);
            this.THE_IMMORTAL = new Immortal(builder);
            builder.pop();
        }
    }

    public static class Mob {
        public final CorpseMobs CORPSES;
        public final ImmortalMobs IMMORTAL;
        public final GulingMobs GULING;
        public final MinionMobs MINION;

        public Mob(ForgeConfigSpec.Builder builder) {
            builder.push("Mobs");
            this.IMMORTAL = new ImmortalMobs(builder);
            this.CORPSES = new CorpseMobs(builder);
            this.GULING = new GulingMobs(builder);
            this.MINION = new MinionMobs(builder);
            builder.pop();
        }
    }

    public static class Entity {
        public final ForgeConfigSpec.DoubleValue guardianLaserShootRadius;
        public final ForgeConfigSpec.BooleanValue guardianLaserCanDestroyBlock;
        public final ForgeConfigSpec.DoubleValue guardianLaserCanDestroyMaxBlockHardness;
        public final ForgeConfigSpec.BooleanValue enableGenerateScorchEntity;
        public final ForgeConfigSpec.BooleanValue enableSpawnFallingBlock;
        public final ForgeConfigSpec.BooleanValue enableRenderFallingBlock;
        public final ForgeConfigSpec.IntValue fallingBlockBelowCheckRange;
        public final ForgeConfigSpec.DoubleValue testerMaxHealth;
        public final ForgeConfigSpec.BooleanValue immuneToEnvironmentalOrStatusDamage;

        public Entity(ForgeConfigSpec.Builder builder) {
            builder.push("Entities");
            builder.push("Guardian Laser");
            this.enableGenerateScorchEntity = BUILDER.comment("If set to 'False' disable scorch generate on the ground").translation(EMConfigHandler.getTranslationKey("guardian_laser_1")).define("Enable scorch generate", true);
            this.guardianLaserShootRadius = BUILDER.comment("Set the maximum shooting distance for players").translation(EMConfigHandler.getTranslationKey("attack_radius")).defineInRange("Set attack radius", 16.0, 1.0, 64.0);
            this.guardianLaserCanDestroyBlock = BUILDER.comment("If set to 'False' disable block destruction by players").translation(EMConfigHandler.getTranslationKey("guardian_laser_2")).define("Enable destroy block", true);
            this.guardianLaserCanDestroyMaxBlockHardness = BUILDER.comment("Set max block hardness for laser destruction").translation(EMConfigHandler.getTranslationKey("guardian_laser_3")).defineInRange("Set laser max hardness", 1.0, 1.0, 3.4028234663852886E38);
            builder.pop();
            builder.push("Falling Block");
            this.enableSpawnFallingBlock = BUILDER.comment("If set to 'False' disable falling block spawn").translation(EMConfigHandler.getTranslationKey("falling_block_1")).define("Enable falling block spawn", true);
            this.enableRenderFallingBlock = BUILDER.comment("If set to 'False' disable falling block rendering").translation(EMConfigHandler.getTranslationKey("falling_block_2")).define("Enable falling block render", true);
            this.fallingBlockBelowCheckRange = BUILDER.comment("Set the maximum range for downward block detection to determine the Y-axis position where the entity spawns").translation(EMConfigHandler.getTranslationKey("falling_block_3")).defineInRange("Set below check range", 3, 1, 10);
            builder.pop();
            builder.push("Tester");
            this.testerMaxHealth = BUILDER.translation(EMConfigHandler.getTranslationKey("tester_1")).defineInRange("Set max health", 20.0, 1.0, 1024.0);
            this.immuneToEnvironmentalOrStatusDamage = BUILDER.translation(EMConfigHandler.getTranslationKey("tester_2")).define("Enable immune to environmental or status damage", true);
            builder.pop();
            builder.pop();
        }
    }

    public static class Item {
        public final ToolConfig GUARDIAN_AXE_TOOL;
        public final ToolConfig NETHERWORLD_KATANA_TOOL;
        public final ToolConfig DEMOLISHER_TOOL;
        public final ForgeConfigSpec.DoubleValue eyeItemCoolingTime;
        public final ForgeConfigSpec.BooleanValue consumeEyeItemOnRelease;
        public final ForgeConfigSpec.DoubleValue SSNCoolingTime;
        public final ForgeConfigSpec.DoubleValue SSNCumulativeMaximumDamage;
        public final ForgeConfigSpec.DoubleValue itemHowitzerCoolingTime;
        public final ForgeConfigSpec.DoubleValue itemHowitzerGrenadeDamage;
        public final ForgeConfigSpec.DoubleValue itemHowitzerGrenadeExplosionRadius;
        public final ForgeConfigSpec.IntValue itemGuardianAxeSweepingLevel;
        public final ForgeConfigSpec.DoubleValue itemGuardianAxeCoolingTime;
        public final ForgeConfigSpec.DoubleValue itemImmortalStaffCoolingTime;
        public final ForgeConfigSpec.BooleanValue enableGhostWarriorSeriesItemDurability;

        public Item(ForgeConfigSpec.Builder builder) {
            builder.push("Items");
            builder.push("Summoning Soul Necklace");
            this.SSNCumulativeMaximumDamage = BUILDER.comment("Set maximum amount of damage a player can take while holding this item").translation(EMConfigHandler.getTranslationKey("summoning_soul_necklace")).defineInRange("Set maximum cumulative damage taken", 50.0, 1.0, 3.4028234663852886E38);
            this.SSNCoolingTime = Item.itemCD(20.0);
            builder.pop();
            builder.push("Howitzer");
            this.itemHowitzerGrenadeDamage = BUILDER.comment("Set Grenade maximum explosion damage(damage to the center of the explosion)").translation(EMConfigHandler.getTranslationKey("howitzer_1")).defineInRange("Set explosion damage cap", 10.0, 1.0, 128.0);
            this.itemHowitzerGrenadeExplosionRadius = BUILDER.comment("Set Grenade explosion radius(the bigger the blast radius, the higher the damage)").translation(EMConfigHandler.getTranslationKey("howitzer_2")).defineInRange("Set explosion radius", 2.5, 1.0, 10.0);
            this.itemHowitzerCoolingTime = Item.itemCD(2.0);
            this.DEMOLISHER_TOOL = new ToolConfig(8.0, 1.6);
            builder.pop();
            builder.push("Guardian Battleaxe");
            this.itemGuardianAxeSweepingLevel = BUILDER.comment("The increase in damage should refer to the Sweeping Edge enchantment").translation(EMConfigHandler.getTranslationKey("guardian_axe")).defineInRange("Set sweep attack level", 1, 0, 4);
            this.itemGuardianAxeCoolingTime = Item.itemCD(5.0);
            this.GUARDIAN_AXE_TOOL = new ToolConfig(15.0, 0.9);
            builder.pop();
            builder.push("Immortal Staff");
            this.itemImmortalStaffCoolingTime = Item.itemCD(1.5);
            builder.pop();
            builder.push("Ghost Warrior Series");
            this.enableGhostWarriorSeriesItemDurability = BUILDER.comment("If set to 'True' armor or weapon will be depleted").translation(EMConfigHandler.getTranslationKey("series_depleted")).define("Enable armor or weapon can be depleted", false);
            this.NETHERWORLD_KATANA_TOOL = new ToolConfig(14.0, 1.4);
            builder.pop();
            builder.push("Eye Of Structure");
            this.consumeEyeItemOnRelease = BUILDER.comment("If set to 'True' eye of structure will be consume item on release").translation(EMConfigHandler.getTranslationKey("eye_of_structure")).define("Consume Item On Release", false);
            this.eyeItemCoolingTime = Item.itemCD(4.0);
            builder.pop();
            builder.pop();
        }

        private static ForgeConfigSpec.DoubleValue itemCD(double defaultCD) {
            String CDComment = "Set item cool down time after player on use (in seconds)";
            String CDPath = "Set item cool down time";
            String CDKey = "item_cd";
            return BUILDER.comment(CDComment).translation(EMConfigHandler.getTranslationKey(CDKey)).defineInRange(CDPath, defaultCD, 0.0, 60.0);
        }
    }
}

