/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.server.message;

import com.eeeab.animate.server.animation.EMAnimatedEntity;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PlayAnimationMessage {
    private int entityID;
    private int animationsIndex;

    public PlayAnimationMessage() {
    }

    public PlayAnimationMessage(int entityID, int animationsIndex) {
        this.entityID = entityID;
        this.animationsIndex = animationsIndex;
    }

    public static void serialize(PlayAnimationMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.entityID);
        buf.m_130130_(message.animationsIndex);
    }

    public static PlayAnimationMessage deserialize(FriendlyByteBuf buf) {
        PlayAnimationMessage message = new PlayAnimationMessage();
        message.entityID = buf.m_130242_();
        message.animationsIndex = buf.m_130242_();
        return message;
    }

    public static class Handler<T extends Entity>
    implements BiConsumer<PlayAnimationMessage, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(PlayAnimationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                Level level;
                Entity entity;
                ServerPlayer sender = context.getSender();
                if (sender != null && (entity = (level = sender.m_9236_()).m_6815_(message.entityID)) != null && message.animationsIndex != -1) {
                    EMAnimationHandler.INSTANCE.sendEMAnimationMessage(entity, ((EMAnimatedEntity)entity).getAnimations()[message.animationsIndex]);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

