/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.server.ai;

import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;

public class AnimationRangeAI<T extends EEEABMobLibrary>
extends Goal {
    protected T attacker;
    protected int seeTime;
    protected double speed;
    protected Item holdWeapon;
    protected int attackInterval;
    protected Supplier<Animation> emAnimationSupplier;
    protected int attackTime = -1;
    protected int strafingTime = -1;
    protected float attackRadiusSqr;
    protected Predicate<T> customFlag;
    protected boolean strafingClockwise;
    protected boolean strafingBackwards;
    protected boolean ignoreWeaponCheck = false;

    public AnimationRangeAI(T mob, double speedModifier, int attackIntervalMin, float attackRadius, Item weapon, Predicate<T> customFlag, Supplier<Animation> animationSupplier) {
        this.attacker = mob;
        this.holdWeapon = weapon;
        this.speed = speedModifier;
        this.emAnimationSupplier = animationSupplier;
        this.customFlag = customFlag;
        this.attackInterval = attackIntervalMin;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (weapon == null) {
            this.ignoreWeaponCheck = true;
        }
    }

    protected boolean isHoldItem() {
        return this.attacker.m_21093_(i -> i.m_150930_(this.holdWeapon));
    }

    public boolean m_8036_() {
        LivingEntity target = this.attacker.m_5448_();
        return this.customFlag.test(this.attacker) && target != null && target.m_6084_() && this.attacker.m_6779_(target) && (this.ignoreWeaponCheck || this.isHoldItem());
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.attacker.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.attacker.m_21561_(true);
    }

    public void m_8041_() {
        this.attacker.m_21561_(false);
        this.attacker.m_21566_().m_24988_(0.0f, 0.0f);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity != null) {
            boolean flag1;
            double d0 = this.attacker.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            boolean flag = this.attacker.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.attacker.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.attacker.m_21573_().m_5624_((Entity)livingentity, this.speed);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.attacker.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.attacker.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.attacker.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                Entity entity = this.attacker.m_275832_();
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                }
                this.attacker.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.attacker.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.attackTime = this.attackInterval;
                ((EEEABMobLibrary)this.attacker).playAnimation(this.emAnimationSupplier.get());
            }
        }
    }
}

