/*
 * Decompiled with CFR 0.152.
 */
package elocindev.teraphobia.forge.event;

import elocindev.necronomicon.api.NecUtilsAPI;
import elocindev.teraphobia.forge.config.TeraphobiaConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnEvents {
    public static void fallbackSpawnEvent(EntityJoinLevelEvent event) {
        LivingEntity living;
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && SpawnEvents.shouldDisable(living = (LivingEntity)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void fallbackFinalizeSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof LivingEntity && SpawnEvents.shouldDisable((LivingEntity)event.getEntity())) {
            event.setSpawnCancelled(true);
        }
    }

    public static boolean shouldDisable(LivingEntity entity) {
        Level level = entity.m_9236_();
        String entityId = NecUtilsAPI.getEntityId((Entity)entity);
        if (level.m_46461_()) {
            for (String pattern : TeraphobiaConfig.INSTANCE.night_only_spawn) {
                if (!entityId.matches(pattern)) continue;
                return true;
            }
        }
        long day = level.m_46468_() / 24000L;
        for (TeraphobiaConfig.TimedSpawnHolder holder : TeraphobiaConfig.INSTANCE.timed_spawns) {
            if (day >= (long)holder.minDay || !entityId.equals(holder.entity)) continue;
            return true;
        }
        return false;
    }
}

