/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.nanny;

import dev.qther.nanny.Config;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nanny")
public class NaNny {
    private static final Logger LOGGER = LogManager.getLogger();

    public NaNny() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent e) {
        float dmg = e.getAmount();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(dmg)) {
            e.setCanceled(true);
            this.applyFlatDamage(le, 5.0f);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent e) {
        float dmg = e.getAmount();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(dmg)) {
            e.setCanceled(true);
            this.applyFlatDamage(le, 5.0f);
        }
    }

    @SubscribeEvent
    public void onAttackEntity(LivingAttackEvent e) {
        float dmg = e.getAmount();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(dmg)) {
            e.setCanceled(true);
            this.applyFlatDamage(le, 5.0f);
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent e) {
        float amount = e.getAmount();
        LivingEntity le = e.getEntity();
        if (Float.isNaN(amount)) {
            e.setCanceled(true);
            return;
        }
        if (Float.isNaN(le.m_21223_())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        LivingEntity le = e.getEntity();
        float hp = le.m_21223_();
        if (Float.isNaN(hp)) {
            e.setCanceled(true);
        }
    }

    private void applyFlatDamage(LivingEntity entity, float damage) {
        float newHealth = entity.m_21223_() - damage;
        entity.m_21153_(Math.max(newHealth, 0.0f));
    }

    private void warn(String msg) {
        if (((Boolean)Config.log.get()).booleanValue()) {
            LOGGER.warn(msg);
        }
    }

    private String getName(LivingEntity e) {
        return e.m_7755_().getString();
    }
}

