/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.config.ServerConfig;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.PayloadHandler;
import dev.terminalmc.clientsort.network.handler.validate.PolicyManager;
import dev.terminalmc.clientsort.network.handler.validate.SchemaValidator;
import dev.terminalmc.clientsort.network.payload.StackFillPayload;
import dev.terminalmc.clientsort.network.payload.StackFillResultPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class StackFillHandler
extends PayloadHandler {
    private StackFillHandler() {
    }

    public static void handle(StackFillPayload payload, MinecraftServer server, ServerPlayer player) {
        server.execute(() -> StackFillHandler.processPayload(server, player, payload.srcContainerId(), menu -> StackFillHandler.checkPolicy(menu, payload.srcSlotIds(), payload.dstSlotIds()), menu -> {
            SchemaValidator.validateSlotArray(player, menu, payload.srcSlotIds());
            SchemaValidator.validateSlotArray(player, menu, payload.dstSlotIds());
        }, menu -> StackFillHandler.fillStacks(menu, payload.srcSlotIds(), payload.dstSlotIds()), StackFillPayload.ID, StackFillResultPayload.ID, (result, message) -> new StackFillResultPayload(result.code, (String)message)));
    }

    private static void fillStacks(AbstractContainerMenu menu, int[] srcSlotIds, int[] dstSlotIds) throws PayloadHandlerException {
        block0: for (int i = srcSlotIds.length - 1; i >= 0; --i) {
            int srcSlotId = srcSlotIds[i];
            Slot srcSlot = (Slot)menu.f_38839_.get(srcSlotId);
            ItemStack srcStack = srcSlot.m_7993_();
            ItemStack srcStackCopy = srcSlot.m_7993_().m_41777_();
            if (srcStack.m_41619_()) continue;
            for (int dstSlotId : dstSlotIds) {
                Slot dstSlot = (Slot)menu.f_38839_.get(dstSlotId);
                ItemStack dstStack = dstSlot.m_7993_();
                ItemStack dstStackCopy = dstSlot.m_7993_().m_41777_();
                if (dstStack.m_41619_() || dstStack.m_41613_() >= dstSlot.m_5866_(dstStack) || !ItemStack.m_150942_((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                ItemStack expected = srcStack.m_255036_(Math.min(srcStack.m_41613_() + dstStack.m_41613_(), dstSlot.m_5866_(dstStack)));
                dstSlot.m_150659_(srcStack);
                if (ServerConfig.serverOptions().validateOperationResults && StackFillHandler.notEqual(dstSlot.m_7993_(), expected)) {
                    String message = String.format("Stack Fill operation failed to safe-insert from slot %d with item '%s' to slot %d with item '%s': Expected '%s' in destination after set, got '%s'!", srcSlotId, srcStackCopy, dstSlotId, dstStackCopy, expected, dstSlot.m_7993_());
                    StackFillHandler.setPolicy(menu, dstSlotIds, message);
                    throw new PayloadHandlerException.InconsistentStateException(message);
                }
                if (srcStack.m_41619_()) continue block0;
            }
        }
    }

    private static void checkPolicy(AbstractContainerMenu menu, int[] srcSlotIds, int[] dstSlotIds) throws PayloadHandlerException.UnsupportedOpException {
        Container srcContainer = srcSlotIds.length > 0 ? ((Slot)menu.f_38839_.get((int)srcSlotIds[0])).f_40218_ : null;
        AbstractContainerMenu srcObject = srcContainer instanceof SimpleContainer ? menu : srcContainer;
        Container dstContainer = dstSlotIds.length > 0 ? ((Slot)menu.f_38839_.get((int)dstSlotIds[0])).f_40218_ : null;
        AbstractContainerMenu dstObject = dstContainer instanceof SimpleContainer ? menu : dstContainer;
        PolicyManager.checkPolicy(srcObject.getClass(), bl -> bl.stackFillEnabled);
        PolicyManager.checkPolicy(dstObject.getClass(), bl -> bl.stackFillEnabled);
    }

    private static void setPolicy(AbstractContainerMenu menu, int[] dstSlotIds, String message) {
        Container dstContainer = dstSlotIds.length > 0 ? ((Slot)menu.f_38839_.get((int)dstSlotIds[0])).f_40218_ : null;
        AbstractContainerMenu object = dstContainer instanceof SimpleContainer ? menu : dstContainer;
        PolicyManager.setPolicy(new ServerClassPolicy(object.getClass().getName(), true, false, true), StackFillPayload.ID.toString(), message);
    }
}

