/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.config.ServerConfig;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.PayloadHandler;
import dev.terminalmc.clientsort.network.handler.validate.PolicyManager;
import dev.terminalmc.clientsort.network.handler.validate.SchemaValidator;
import dev.terminalmc.clientsort.network.payload.CollectPayload;
import dev.terminalmc.clientsort.network.payload.CollectResultPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CollectHandler
extends PayloadHandler {
    private CollectHandler() {
    }

    public static void handle(CollectPayload payload, MinecraftServer server, ServerPlayer player) {
        server.execute(() -> CollectHandler.processPayload(server, player, payload.containerId(), menu -> CollectHandler.checkPolicy(player, menu, payload.slotIds()), menu -> SchemaValidator.validateSlotArray(player, menu, payload.slotIds()), menu -> CollectHandler.collect(menu, payload.slotIds()), CollectPayload.ID, CollectResultPayload.ID, (result, message) -> new CollectResultPayload(result.code, (String)message)));
    }

    private static void collect(AbstractContainerMenu menu, int[] slotIds) throws PayloadHandlerException {
        block0: for (int i = slotIds.length - 1; i >= 0; --i) {
            int srcSlotId = slotIds[i];
            Slot srcSlot = (Slot)menu.f_38839_.get(srcSlotId);
            ItemStack srcStack = srcSlot.m_7993_();
            ItemStack srcStackCopy = srcStack.m_41777_();
            if (srcStack.m_41619_() || srcStack.m_41613_() >= srcStack.m_41720_().m_41459_()) continue;
            for (int j = 0; j < i; ++j) {
                int dstSlotId = slotIds[j];
                Slot dstSlot = (Slot)menu.f_38839_.get(dstSlotId);
                ItemStack dstStack = dstSlot.m_7993_();
                ItemStack dstStackCopy = dstStack.m_41777_();
                if (dstStack.m_41619_() || dstStack.m_41613_() >= dstStack.m_41720_().m_41459_() || !ItemStack.m_150942_((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                dstSlot.m_150659_(srcStack);
                if (ServerConfig.serverOptions().validateOperationResults) {
                    ItemStack expected = srcStackCopy.m_255036_(Math.min(srcStackCopy.m_41613_() + dstStackCopy.m_41613_(), dstSlot.m_5866_(srcStackCopy)));
                    if (CollectHandler.notEqual(dstSlot.m_7993_(), expected)) {
                        String message = String.format("Collect operation failed to safe-insert from slot %d with item '%s' to slot %d with item '%s': Expected '%s' in destination after set, got '%s'!", srcSlotId, srcStackCopy, dstSlotId, dstStackCopy, expected, dstSlot.m_7993_());
                        CollectHandler.setPolicy(menu, slotIds, message);
                        throw new PayloadHandlerException.InconsistentStateException(message);
                    }
                }
                if (srcStack.m_41619_()) continue block0;
            }
        }
    }

    private static void checkPolicy(ServerPlayer player, AbstractContainerMenu menu, int[] slotIds) throws PayloadHandlerException.UnsupportedOpException {
        AbstractContainerMenu object;
        Container container = slotIds.length > 0 ? ((Slot)menu.f_38839_.get((int)slotIds[0])).f_40218_ : null;
        Object object2 = object = container instanceof SimpleContainer ? menu : container;
        if (container != player.m_150109_()) {
            PolicyManager.checkPolicy(object.getClass(), bl -> bl.sortEnabled);
        }
    }

    private static void setPolicy(AbstractContainerMenu menu, int[] slotIds, String message) {
        Container container = slotIds.length > 0 ? ((Slot)menu.f_38839_.get((int)slotIds[0])).f_40218_ : null;
        AbstractContainerMenu object = container instanceof SimpleContainer ? menu : container;
        PolicyManager.setPolicy(new ServerClassPolicy(object.getClass().getName(), false, true, true), CollectPayload.ID.toString(), message);
    }
}

