/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.compat.itemlocks.ItemLocksWrapper;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientCreativeOperator;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientSurvivalOperator;
import dev.terminalmc.clientsort.client.inventory.operator.server.ServerOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.util.Scope;
import dev.terminalmc.clientsort.client.order.SortOrder;
import dev.terminalmc.clientsort.client.platform.ClientServices;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.util.SlotLogUtil;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public abstract class SingleUseOperator<T extends Operation> {
    private boolean hasOperated = false;
    protected final AbstractContainerScreen<?> screen;
    protected final ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper;
    protected final T operation;
    protected final Slot originSlot;
    protected final Slot[] originScopeSlots;
    protected final ItemStack[] originScopeStacks;
    protected final Slot[] otherScopeSlots;
    protected final ItemStack[] otherScopeStacks;

    public SingleUseOperator(AbstractContainerScreen<?> screen, ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper, Slot originSlot, T operation) {
        this.screen = screen;
        this.screenHelper = screenHelper;
        this.originSlot = originSlot;
        this.operation = operation;
        Scope originScope = screenHelper.getScope(originSlot);
        this.originScopeSlots = this.collectSlots(originScope);
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Discovered {} slots in origin scope ({} - {}):", this.originScopeSlots.length, originScope.ordinal(), originScope.name());
            dev.terminalmc.clientsort.client.ClientSort.LOG.info(SlotLogUtil.listSlotIds(List.of(this.originScopeSlots)), new Object[0]);
        }
        this.originScopeStacks = new ItemStack[this.originScopeSlots.length];
        for (int i = 0; i < this.originScopeSlots.length; ++i) {
            this.originScopeStacks[i] = this.originScopeSlots[i].m_7993_().m_41777_();
        }
        Scope otherScope = switch (originScope) {
            case Scope.PLAYER_INV -> Scope.CONTAINER_INV;
            case Scope.CONTAINER_INV -> Scope.PLAYER_INV;
            default -> Scope.INVALID;
        };
        this.otherScopeSlots = this.collectSlots(otherScope);
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Discovered {} slots in other scope ({} - {}):", this.otherScopeSlots.length, otherScope.ordinal(), otherScope.name());
            dev.terminalmc.clientsort.client.ClientSort.LOG.info(SlotLogUtil.listSlotIds(List.of(this.otherScopeSlots)), new Object[0]);
        }
        this.otherScopeStacks = new ItemStack[this.otherScopeSlots.length];
        for (int i = 0; i < this.otherScopeSlots.length; ++i) {
            this.otherScopeStacks[i] = this.otherScopeSlots[i].m_7993_().m_41777_();
        }
    }

    private Slot[] collectSlots(Scope scope) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (scope == Scope.INVALID) {
            return new Slot[0];
        }
        ItemStack testItem = Items.f_151033_.m_7968_();
        ArrayList<Slot> collectedSlots = new ArrayList<Slot>();
        for (Slot slot : this.screen.m_6262_().f_38839_) {
            ClassPolicy policy;
            Object object;
            int slotId = ((ISlot)slot).clientsort$getIndexInMenu();
            int slotIdx = ((ISlot)slot).clientsort$getIndexInContainer();
            if (this.screenHelper.getScope(slot) != scope || (!slot.m_6657_() ? !slot.f_40218_.m_7013_(slotId, testItem) || !slot.m_5857_(testItem) : player != null && !slot.m_8010_((Player)player))) continue;
            if (ItemLocksWrapper.isLocked(slot) || (object = dev.terminalmc.clientsort.client.ClientSort.getObj(slot, this.screen.m_6262_())) == null || (policy = PolicyManager.getPolicy(object.getClass())) != null && policy.ignoredSlots().contains(slotIdx)) continue;
            collectedSlots.add(slot);
        }
        return collectedSlots.toArray(new Slot[0]);
    }

    private boolean canPerform(Operation op) {
        if (!((Enum)this.operation).equals((Object)op)) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Cannot perform op {} using an operator created for op {}!", new Object[]{op, this.operation});
            return false;
        }
        return true;
    }

    private boolean hasOperated() {
        if (this.hasOperated) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.warn("{} can only be used once!", this.getClass().getSimpleName());
            return true;
        }
        this.hasOperated = true;
        return false;
    }

    @Nullable
    public static SingleUseOperator<Operation> getOperator(AbstractContainerScreen<?> screen, ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper, Slot originSlot, Operation operation, boolean onlyClient) {
        block15: {
            Object object = dev.terminalmc.clientsort.client.ClientSort.getObj(originSlot, screen.m_6262_());
            if (object == null) {
                return null;
            }
            @Nullable ClassPolicy policy = PolicyManager.getPolicy(object.getClass());
            if (policy == null) break block15;
            switch (operation) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case SORT: {
                    if (!policy.canSort()) break;
                    break block15;
                }
                case STACK_FILL: {
                    if (!policy.canStackFill()) break;
                    break block15;
                }
                case MATCH_TRANSFER: {
                    if (!policy.canMatchTransfer()) break;
                    break block15;
                }
                case TRANSFER: {
                    if (policy.canTransfer()) break block15;
                }
            }
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Operation {} is disallowed by policy for class {}!", operation.name(), policy.getClass());
            }
            return null;
        }
        if (!onlyClient && Config.options().useServerAcceleration && ClientServices.PLATFORM.canSendToServer(operation.id)) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing server operator for {}", operation.name());
            }
            return new ServerOperator<Operation>(screen, screenHelper, originSlot, operation);
        }
        if (dev.terminalmc.clientsort.client.ClientSort.operatingClient) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.warn("Client operation is unavailable: another operation is in progress!", new Object[0]);
            }
            return null;
        }
        if (Minecraft.m_91087_().f_91074_.m_7500_() && screen instanceof CreativeModeInventoryScreen) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing client-creative operator for {}", operation.name());
            }
            return new ClientCreativeOperator<Operation>(screen, screenHelper, originSlot, operation);
        }
        if (ClientSort.debug()) {
            dev.terminalmc.clientsort.client.ClientSort.LOG.info("Preparing client-survival operator for {}", operation.name());
        }
        return new ClientSurvivalOperator<Operation>(screen, screenHelper, originSlot, operation);
    }

    public void trySort(SortOrder sortOrder) {
        if (!this.canPerform(Operation.SORT)) {
            return;
        }
        if (this.hasOperated()) {
            return;
        }
        this.sort(sortOrder);
    }

    public void tryFillStacks() {
        if (!this.canPerform(Operation.STACK_FILL)) {
            return;
        }
        if (this.hasOperated()) {
            return;
        }
        this.fillStacks();
    }

    public void tryMatchTransfer() {
        if (!this.canPerform(Operation.MATCH_TRANSFER)) {
            return;
        }
        if (this.hasOperated()) {
            return;
        }
        this.matchTransfer();
    }

    public void tryTransfer() {
        if (!this.canPerform(Operation.TRANSFER)) {
            return;
        }
        if (this.hasOperated()) {
            return;
        }
        this.transfer();
    }

    protected abstract void sort(SortOrder var1);

    protected abstract void fillStacks();

    protected abstract void matchTransfer();

    protected abstract void transfer();

    protected static Slot[] collectMatchingSlots(Slot[] originSlots, ItemStack[] otherStacks, boolean alwaysMatchByType, Set<Item> typeMatchItems) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (Slot slot : originSlots) {
            if (!SingleUseOperator.containsMatchingStack(otherStacks, slot.m_7993_(), alwaysMatchByType, typeMatchItems)) continue;
            slots.add(slot);
        }
        return slots.toArray(new Slot[0]);
    }

    protected static boolean containsMatchingStack(ItemStack[] stacks, ItemStack stack, boolean alwaysMatchByType, Set<Item> typeMatchItems) {
        for (ItemStack s : stacks) {
            if (!SingleUseOperator.stacksMatch(s, stack, alwaysMatchByType, typeMatchItems)) continue;
            return true;
        }
        return false;
    }

    protected static boolean stacksMatch(ItemStack a, ItemStack b, boolean alwaysMatchByType, Set<Item> typeMatchItems) {
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b) || ItemStack.m_41656_((ItemStack)a, (ItemStack)b) && (alwaysMatchByType || typeMatchItems.contains(a.m_41720_()));
    }
}

