/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui.screen.edit;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Policy;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.Localization;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorScreen
extends Screen {
    private final Screen lastScreen;
    private final AbstractContainerScreen<?> underlay;
    private final LinkedList<TriggerButton> buttons = new LinkedList();
    public final Set<Integer> ignoredSlots = new TreeSet<Integer>();
    private TriggerButton rep;
    private String lowestPolicyKey;
    private boolean dragging;

    public EditorScreen(AbstractContainerScreen<?> underlay, TriggerButton button) {
        this(underlay, button, (Screen)underlay);
    }

    public EditorScreen(AbstractContainerScreen<?> underlay, TriggerButton button, Screen lastScreen) {
        super((Component)Localization.localized("title", "positionEditor", new Object[0]));
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.lastScreen = lastScreen;
        this.underlay = underlay;
        this.rep = button;
        this.buttons.add(button);
    }

    public void m_7856_() {
        super.m_7856_();
        this.underlay.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        if (!this.reloadButtonsAndIgnoredSlots()) {
            this.m_169413_();
            return;
        }
        this.rebuildGui();
    }

    private boolean reloadButtonsAndIgnoredSlots() {
        this.buttons.clear();
        this.ignoredSlots.clear();
        this.buttons.addAll(this.getButtons());
        if (this.buttons.size() != 4) {
            if (ClientSort.debug()) {
                dev.terminalmc.clientsort.client.ClientSort.LOG.error("Failed to reload buttons on PositionEditScreen: Button list is too small (expected: {}, actual: {})", 4, this.buttons.size());
            }
            return false;
        }
        this.rep = this.buttons.getFirst();
        ClassPolicy policy = Config.options().classPolicies.get(this.rep.activePolicyKey);
        if (policy != null) {
            this.buttons.forEach(button -> {
                button.f_93623_ = button.getPolicyStatus(policy);
            });
            this.ignoredSlots.addAll(policy.ignoredSlots());
        }
        AbstractContainerMenu keyObject = this.rep.container instanceof SimpleContainer ? this.underlay.m_6262_() : this.rep.container;
        this.lowestPolicyKey = keyObject.getClass().getName();
        return true;
    }

    protected abstract LinkedList<TriggerButton> getButtons();

    private void rebuildGui() {
        this.m_169413_();
        Objects.requireNonNull(this.f_96547_);
        StringWidget titleWidget = new StringWidget(0, 2, this.f_96543_, 9, this.f_96539_, this.f_96547_);
        this.m_142416_((GuiEventListener)titleWidget);
        int numButtons = 10;
        int x = 2;
        int movingY = this.f_96544_ - 21 * numButtons;
        int width = 100;
        int height = 20;
        Button instructionsButton = Button.m_253074_((Component)Localization.localized("editor", "instructions", new Object[0]), button -> {}).m_257505_(Tooltip.m_257550_((Component)Localization.localized("editor", "instructions.tooltip.1", new Object[0]).m_130946_("\n\n").m_7220_((Component)Localization.localized("editor", "instructions.tooltip.2", new Object[0])).m_130946_("\n\n").m_7220_((Component)Localization.localized("editor", "instructions.tooltip.3", new Object[0])).m_130946_("\n\n").m_7220_((Component)Localization.localized("editor", "instructions.tooltip.4", new Object[0])).m_130946_("\n\n").m_7220_((Component)Localization.localized("editor", "instructions.tooltip.5", new Object[0])))).m_252794_(x, movingY).m_253046_(width, height).m_253136_();
        instructionsButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)instructionsButton);
        Button toggleVisibilityButton = Button.m_253074_((Component)Localization.localized("editor", "toggleVisibility", new Object[0]), button -> {
            boolean status = this.buttons.stream().noneMatch(b -> b.f_93623_);
            this.buttons.forEach(b -> {
                b.f_93623_ = status;
            });
        }).m_257505_(Tooltip.m_257550_((Component)Localization.localized("editor", "toggleVisibility.tooltip", new Object[0]))).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        this.m_142416_((GuiEventListener)toggleVisibilityButton);
        Button unignoreSlotsButton = Button.m_253074_((Component)Localization.localized("editor", "unignoreSlots", new Object[0]), button -> this.ignoredSlots.clear()).m_257505_(Tooltip.m_257550_((Component)Localization.localized("editor", "unignoreSlots.tooltip", new Object[0]))).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        this.m_142416_((GuiEventListener)unignoreSlotsButton);
        Button moveToDefaultButton = Button.m_253074_((Component)Localization.localized("editor", "moveToDefault", new Object[0]), button -> {
            Vec2i before = this.buttons.getFirst().offset;
            this.buttons.getFirst().offset = Config.options().layoutOffset;
            this.repositionButtons(this.buttons.getFirst(), before);
        }).m_257505_(Tooltip.m_257550_((Component)Localization.localized("editor", "moveToDefault.tooltip", new Object[0]))).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        this.m_142416_((GuiEventListener)moveToDefaultButton);
        Button saveAsDefaultButton = Button.m_253074_((Component)Localization.localized("editor", "saveAsDefault", new Object[0]), button -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(confirm -> {
            if (confirm) {
                Config.options().layoutOffset = this.buttons.getFirst().offset;
                Config.save();
                this.m_7856_();
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        }, (Component)Localization.localized("title", "confirm.saveAsDefault", new Object[0]), (Component)Localization.localized("message", "confirm.saveAsDefault", new Object[0])))).m_257505_(Tooltip.m_257550_((Component)Localization.localized("editor", "saveAsDefault.tooltip", new Object[0]))).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        this.m_142416_((GuiEventListener)saveAsDefaultButton);
        Button splitPolicyButton = Button.m_253074_((Component)Localization.localized("editor", "splitPolicy", new Object[0]), button -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(confirm -> {
            if (confirm) {
                Config.options().classPolicies.put(this.lowestPolicyKey, new ClassPolicy(this.lowestPolicyKey, this.buttons.getFirst().offset, this.buttons.getFirst().operationAllowed ? (this.buttons.getFirst().f_93623_ ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, this.buttons.get((int)1).operationAllowed ? (this.buttons.getFirst().f_93623_ ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, this.buttons.get((int)2).operationAllowed ? (this.buttons.getFirst().f_93623_ ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, this.buttons.get((int)3).operationAllowed ? (this.buttons.getFirst().f_93623_ ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, new TreeSet<Integer>(this.ignoredSlots)));
                Config.save();
                this.m_7856_();
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        }, (Component)Localization.localized("title", "confirm.splitPolicy", new Object[0]), (Component)Localization.localized("message", "confirm.splitPolicy", Component.m_237113_((String)(this.rep.activePolicyKey == null ? this.lowestPolicyKey : this.rep.activePolicyKey)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)this.lowestPolicyKey).m_130940_(ChatFormatting.GOLD))))).m_257505_(Tooltip.m_257550_((Component)Localization.localized("editor", "splitPolicy.tooltip", new Object[0]))).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        splitPolicyButton.f_93623_ = this.rep.activePolicyKey != null && !this.rep.activePolicyKey.equals(this.lowestPolicyKey);
        this.m_142416_((GuiEventListener)splitPolicyButton);
        Button undoChangesButton = Button.m_253074_((Component)Localization.localized("editor", "undoChanges", new Object[0]), button -> this.m_7856_()).m_257505_(Tooltip.m_257550_((Component)Localization.localized("editor", "undoChanges.tooltip", new Object[0]))).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        this.m_142416_((GuiEventListener)undoChangesButton);
        Button reselectButton = Button.m_253074_((Component)Localization.localized("editor", "reselect", new Object[0]), button -> {
            this.m_7379_();
            Minecraft.m_91087_().m_91152_((Screen)new SelectorScreen(this.underlay, this));
        }).m_257505_(Tooltip.m_257550_((Component)Localization.localized("editor", "reselect.tooltip", new Object[0]))).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        this.m_142416_((GuiEventListener)reselectButton);
        Button cancelButton = Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.m_7379_()).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
        Button doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.saveAndClose()).m_252794_(x, movingY += 21).m_253046_(width, height).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.underlay.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        for (Slot slot : this.underlay.m_6262_().f_38839_) {
            Object object = dev.terminalmc.clientsort.client.ClientSort.getObj(slot, this.underlay.m_6262_());
            if (object == null || !object.getClass().getName().equals(this.lowestPolicyKey) || !this.ignoredSlots.contains(((ISlot)slot).clientsort$getIndexInContainer())) continue;
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, "\u274c", ((AbstractContainerScreenAccessor)this.underlay).clientsort$getLeftPos() + slot.f_40220_, ((AbstractContainerScreenAccessor)this.underlay).clientsort$getTopPos() + slot.f_40221_, 0xFF0000);
        }
        if (this.buttons.isEmpty()) {
            return;
        }
        this.drawLineFor(graphics, this.buttons.getFirst());
        Vec2i offset = this.buttons.getFirst().offset;
        String string = Localization.localized("editor", "offset", offset.x(), offset.y()).getString();
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, string, 105, this.f_96544_ - (9 + 1) * 3, -1);
        MutableComponent mutableComponent = Localization.localized("editor", "policyKey.current", this.rep.activePolicyKey == null ? Localization.localized("editor", "policyKey.unset", new Object[0]) : this.rep.activePolicyKey);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280430_(this.f_96547_, (Component)mutableComponent, 105, this.f_96544_ - (9 + 1) * 2, -1);
        MutableComponent mutableComponent2 = Localization.localized("editor", "policyKey.menu", this.lowestPolicyKey);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280430_(this.f_96547_, (Component)mutableComponent2, 105, this.f_96544_ - (9 + 1), -1);
        for (TriggerButton cb : this.buttons) {
            cb.m_87963_(graphics, mouseX, mouseY, partialTick);
        }
    }

    private void drawLineFor(GuiGraphics graphics, TriggerButton button) {
        graphics.m_280656_(button.m_252754_() - button.offset.x(), button.m_252754_(), button.m_252907_(), -4473925);
        graphics.m_280315_(button.m_252754_() - button.offset.x(), button.m_252907_() - button.offset.y(), button.m_252907_(), -4473925);
    }

    public void m_7379_() {
        super.m_7379_();
        this.lastScreen.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    public void saveAndClose() {
        @Nullable Vec2i offset = this.buttons.getFirst().offset.equals(Config.options().layoutOffset) ? null : this.buttons.getFirst().offset;
        this.buttons.forEach(b -> b.savePolicy(offset, this.ignoredSlots));
        Config.save();
        this.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Vec2i movement;
        int distance = Screen.m_96638_() ? 6 : 1;
        switch (keyCode) {
            case 263: {
                Vec2i vec2i = new Vec2i(-distance, 0);
                break;
            }
            case 262: {
                Vec2i vec2i = new Vec2i(distance, 0);
                break;
            }
            case 265: {
                Vec2i vec2i = new Vec2i(0, -distance);
                break;
            }
            case 264: {
                Vec2i vec2i = new Vec2i(0, distance);
                break;
            }
            default: {
                Vec2i vec2i = movement = null;
            }
        }
        if (movement != null) {
            Vec2i before = this.rep.offset;
            this.rep.offset = this.rep.offset.add(movement);
            this.repositionButtons(this.rep, before);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            this.dragging = false;
            return true;
        }
        for (TriggerButton cb : this.buttons) {
            if (!cb.m_5953_(mouseX, mouseY)) continue;
            cb.m_6375_(mouseX, mouseY, mouseButton);
            this.rep = cb;
            this.dragging = true;
            return true;
        }
        for (Slot slot : this.underlay.m_6262_().f_38839_) {
            Object object;
            if (!((AbstractContainerScreenAccessor)this.underlay).clientsort$isHovering(slot, mouseX, mouseY) || (object = dev.terminalmc.clientsort.client.ClientSort.getObj(slot, this.underlay.m_6262_())) == null || !object.getClass().getName().equals(this.lowestPolicyKey)) continue;
            int slotId = ((ISlot)slot).clientsort$getIndexInContainer();
            if (this.ignoredSlots.contains(slotId)) {
                this.ignoredSlots.remove(slotId);
                continue;
            }
            this.ignoredSlots.add(slotId);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            Vec2i before = this.rep.offset;
            if (this.rep.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                this.repositionButtons(this.rep, before);
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.dragging = false;
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    private void repositionButtons(TriggerButton button, Vec2i before) {
        if (!button.offset.equals(before)) {
            Vec2i diff = button.offset.subtract(before);
            for (TriggerButton cb : this.buttons) {
                if (cb == button) continue;
                cb.offset = cb.offset.add(diff);
            }
        }
    }
}

