/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.core.data.recipes;

import com.soytutta.mynethersdelight.common.registry.MNDItems;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ItemAbilities;
import vectorwing.farmersdelight.common.crafting.ingredient.ItemAbilityIngredient;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class MNDCuttingRecipes {
    public static void register(RecipeOutput output) {
        MNDCuttingRecipes.cuttingAnimalItems(output);
        MNDCuttingRecipes.strippingWood(output);
        MNDCuttingRecipes.salvagingWoodenFurniture(output);
        MNDCuttingRecipes.cuttingVegetables(output);
        MNDCuttingRecipes.cuttingFoods(output);
    }

    private static void cuttingAnimalItems(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASTA.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MNDItems.GHASMATI.get())).addResultWithChance((ItemLike)MNDItems.GHASMATI.get(), 0.05f).build(output, "mynethersdelight:cutting/ghasmati");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.STRIDER_ROCK.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)MNDItems.STRIDER_EGG.get())).addResultWithChance((ItemLike)Items.BONE_MEAL, 0.25f).build(output, "mynethersdelight:cutting/strider_egg");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.STRIDER_SLICE.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MNDItems.MINCED_STRIDER.get()), (int)2).addResult((ItemLike)Items.STRING).addResultWithChance((ItemLike)Items.STRING, 0.5f, 2).build(output, "mynethersdelight:cutting/minced_strider");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_LOIN.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MNDItems.HOGLIN_SAUSAGE.get()), (int)2).build(output, "mynethersdelight:cutting/hoglin_sausage");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_HIDE.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)Items.LEATHER, (int)4).addResultWithChance((ItemLike)Items.LEATHER, 0.5f, 2).build(output, "mynethersdelight:cutting/hoglin_hide");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_ROD}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)Items.BLAZE_POWDER, (int)3).addResultWithChance((ItemLike)Items.BLAZE_POWDER, 0.25f, 1).build(output, "mynethersdelight:cutting/balze_rod");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_TROPHY.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MNDItems.SKOGLIN_TROPHY.get())).addResult((ItemLike)Items.LEATHER).addResultWithChance((ItemLike)Items.LEATHER, 0.5f, 2).build(output, "mynethersdelight:cutting/skoglin_trophy");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.ZOGLIN_TROPHY.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MNDItems.SKOGLIN_TROPHY.get())).addResult((ItemLike)Items.ROTTEN_FLESH).addResultWithChance((ItemLike)Items.ROTTEN_FLESH, 0.5f, 2).build(output, "mynethersdelight:cutting/skoglin_trophy_alt");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.WAXED_HOGLIN_TROPHY.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_WAX_OFF).toVanilla(), (ItemLike)((ItemLike)MNDItems.HOGLIN_TROPHY.get())).build(output, "mynethersdelight:cutting/hoglin_trophy");
    }

    private static void strippingWood(RecipeOutput output) {
        MNDCuttingRecipes.stripLogForBark(output, (ItemLike)MNDItems.BLOCK_OF_POWDERY_CANNON.get(), (ItemLike)MNDItems.BLOCK_OF_STRIPPED_POWDERY_CANNON.get());
    }

    private static void salvagingWoodenFurniture(RecipeOutput output) {
        MNDCuttingRecipes.salvagePlankFromFurniture(output, (ItemLike)MNDItems.POWDERY_PLANKS.get(), (ItemLike)MNDItems.POWDERY_DOOR.get(), (ItemLike)MNDItems.POWDERY_TRAPDOOR.get(), (ItemLike)MNDItems.POWDERY_SIGN.get(), (ItemLike)MNDItems.POWDERY_HANGING_SIGN.get());
    }

    private static void cuttingVegetables(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.CARVED_PUMPKIN}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ModItems.PUMPKIN_SLICE.get()), (int)1).addResultWithChance((ItemLike)Items.PUMPKIN_SEEDS, 0.25f, 1).build(output, "farmersdelight:cutting/pumpkin_slice_alt");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)Items.GUNPOWDER, (int)1).addResultWithChance((ItemLike)Items.GUNPOWDER, 0.25f, 1).build(output, "mynethersdelight:cutting/gunpowder_cane");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.BULLET_PEPPER.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)Items.BLAZE_POWDER, (int)1).addResultWithChance((ItemLike)Items.BLAZE_POWDER, 0.25f, 1).build(output, "mynethersdelight:cutting/bullet_pepper");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.CRIMSON_FUNGUS_COLONY.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)Items.CRIMSON_FUNGUS, (int)5).build(output, "mynethersdelight:cutting/crimson_fungus");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.WARPED_FUNGUS_COLONY.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)Items.WARPED_FUNGUS, (int)5).build(output, "mynethersdelight:cutting/warped_fungus");
    }

    private static void cuttingFoods(RecipeOutput output) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.MAGMA_CAKE.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MNDItems.MAGMA_CAKE_SLICE.get()), (int)7).build(output, "mynethersdelight:cutting/magma_cake");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.BREAD_LOAF_BLOCK.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MNDItems.SLICES_OF_BREAD.get()), (int)5).build(output, "mynethersdelight:cutting/slices_of_bread");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHAST_SOURDOUGH.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)MNDItems.GHAST_DOUGH.get()), (int)3).build(output, "mynethersdelight:cutting/ghast_dough");
    }

    private static void stripLogForBark(RecipeOutput output, ItemLike log, ItemLike strippedLog) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{log}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_STRIP).toVanilla(), (ItemLike)strippedLog).addResult((ItemLike)ModItems.STRAW.get()).addSound(SoundEvents.AXE_STRIP).build(output);
    }

    private static void salvagePlankFromFurniture(RecipeOutput output, ItemLike plank, ItemLike door, ItemLike trapdoor, ItemLike sign, ItemLike hangingSign) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{door}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)plank).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{trapdoor}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)plank).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{sign}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)plank).build(output);
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{hangingSign}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)plank).build(output);
    }
}

