/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.item;

import com.google.common.collect.Lists;
import com.soytutta.mynethersdelight.common.registry.MNDEffects;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.MathUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class HotCreamConeItem
extends ConsumableItem {
    public static final List<MobEffectInstance> EFFECTS = Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3000, 1), new MobEffectInstance(MNDEffects.GPUNGENT, 3000, 0)});

    public HotCreamConeItem(Item.Properties properties) {
        super(properties, false, true);
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        boolean removedEffect = false;
        if (!consumer.fireImmune()) {
            consumer.setRemainingFireTicks(10);
        }
        Iterator iterator = consumer.getActiveEffects().iterator();
        while (iterator.hasNext() && !removedEffect) {
            MobEffectInstance effectInstance = (MobEffectInstance)iterator.next();
            if (!effectInstance.getCures().contains(EffectCures.MILK)) continue;
            int remainingDuration = effectInstance.getDuration();
            int fireResistanceDuration = remainingDuration / 5;
            int pungentDuration = fireResistanceDuration / 2;
            if (fireResistanceDuration > 200) {
                consumer.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, fireResistanceDuration * 3));
            } else {
                consumer.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400));
            }
            if (pungentDuration > 200) {
                consumer.addEffect(new MobEffectInstance(MNDEffects.GPUNGENT, pungentDuration * 3, 2));
            } else {
                consumer.addEffect(new MobEffectInstance(MNDEffects.GPUNGENT, 600, 2));
            }
            consumer.removeEffect(effectInstance.getEffect());
            removedEffect = true;
        }
        if (removedEffect) {
            level.playSound(null, consumer.blockPosition(), SoundEvents.LAVA_EXTINGUISH, consumer.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (!((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            return;
        }
        MutableComponent textWhenFeeding = TextUtils.getTranslation((String)"tooltip.strider_feed.when_feeding", (Object[])new Object[0]);
        tooltip.add((Component)textWhenFeeding.withStyle(ChatFormatting.GRAY));
        for (MobEffectInstance effectInstance : EFFECTS) {
            MutableComponent effectDescription = Component.literal((String)" ");
            MutableComponent effectName = Component.translatable((String)effectInstance.getDescriptionId());
            effectDescription.append((Component)effectName);
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            if (effectInstance.getAmplifier() > 0) {
                effectDescription.append(" ").append((Component)Component.translatable((String)("potion.potency." + effectInstance.getAmplifier())));
            }
            if (effectInstance.getDuration() > 20) {
                effectDescription.append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)context.tickRate())).append(")");
            }
            tooltip.add((Component)effectDescription.withStyle(effect.getCategory().getTooltipFormatting()));
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Strider strider;
        if (target instanceof Strider && (strider = (Strider)target).isAlive()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @EventBusSubscriber(modid="mynethersdelight", bus=EventBusSubscriber.Bus.GAME)
    public static class StriderFoodEvent {
        @SubscribeEvent
        public static void onStriderFoodApplied(PlayerInteractEvent.EntityInteract event) {
            Strider strider;
            Player player = event.getEntity();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof Strider && (strider = (Strider)target).isAlive() && itemStack.getItem().equals(MNDItems.HOT_CREAM_CONE.get())) {
                strider.setHealth(strider.getMaxHealth());
                for (MobEffectInstance effect : EFFECTS) {
                    strider.addEffect(new MobEffectInstance(effect));
                }
                strider.level().playSound(null, target.blockPosition(), SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
                for (int i = 0; i < 5; ++i) {
                    double xSpeed = MathUtils.RAND.nextGaussian() * 0.02;
                    double ySpeed = MathUtils.RAND.nextGaussian() * 0.02;
                    double zSpeed = MathUtils.RAND.nextGaussian() * 0.02;
                    strider.level().addParticle((ParticleOptions)ModParticleTypes.STAR.get(), strider.getRandomX(1.0), strider.getRandomY() + 0.5, strider.getRandomZ(1.0), xSpeed, ySpeed, zSpeed);
                }
                if (itemStack.getCraftingRemainingItem() != ItemStack.EMPTY && !player.isCreative()) {
                    player.addItem(itemStack.getCraftingRemainingItem());
                    itemStack.shrink(1);
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

